/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BalancingStrategy {
    SPOT_ONLY("SPOT_ONLY"),
    SPOT_PREFERRED("SPOT_PREFERRED"),
    ON_DEMAND_ONLY("ON_DEMAND_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BalancingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BalancingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BalancingStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BalancingStrategy> knownValues() {
        return Stream.of(BalancingStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

