/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchGameSessionsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, SearchGameSessionsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(SearchGameSessionsRequest.getter(SearchGameSessionsRequest::fleetId)).setter(SearchGameSessionsRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasId").getter(SearchGameSessionsRequest.getter(SearchGameSessionsRequest::aliasId)).setter(SearchGameSessionsRequest.setter(Builder::aliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()}).build();
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterExpression").getter(SearchGameSessionsRequest.getter(SearchGameSessionsRequest::filterExpression)).setter(SearchGameSessionsRequest.setter(Builder::filterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final SdkField<String> SORT_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortExpression").getter(SearchGameSessionsRequest.getter(SearchGameSessionsRequest::sortExpression)).setter(SearchGameSessionsRequest.setter(Builder::sortExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortExpression").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(SearchGameSessionsRequest.getter(SearchGameSessionsRequest::limit)).setter(SearchGameSessionsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchGameSessionsRequest.getter(SearchGameSessionsRequest::nextToken)).setter(SearchGameSessionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ALIAS_ID_FIELD, FILTER_EXPRESSION_FIELD, SORT_EXPRESSION_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String fleetId;
    private final String aliasId;
    private final String filterExpression;
    private final String sortExpression;
    private final Integer limit;
    private final String nextToken;

    private SearchGameSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.filterExpression = builder.filterExpression;
        this.sortExpression = builder.sortExpression;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String aliasId() {
        return this.aliasId;
    }

    public final String filterExpression() {
        return this.filterExpression;
    }

    public final String sortExpression() {
        return this.sortExpression;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGameSessionsRequest)) {
            return false;
        }
        SearchGameSessionsRequest other = (SearchGameSessionsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.sortExpression(), other.sortExpression()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchGameSessionsRequest").add("FleetId", (Object)this.fleetId()).add("AliasId", (Object)this.aliasId()).add("FilterExpression", (Object)this.filterExpression()).add("SortExpression", (Object)this.sortExpression()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "AliasId": {
                return Optional.ofNullable(clazz.cast(this.aliasId()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
            case "SortExpression": {
                return Optional.ofNullable(clazz.cast(this.sortExpression()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchGameSessionsRequest, T> g) {
        return obj -> g.apply((SearchGameSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String aliasId;
        private String filterExpression;
        private String sortExpression;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGameSessionsRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.aliasId(model.aliasId);
            this.filterExpression(model.filterExpression);
            this.sortExpression(model.sortExpression);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getSortExpression() {
            return this.sortExpression;
        }

        @Override
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchGameSessionsRequest build() {
            return new SearchGameSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchGameSessionsRequest> {
        public Builder fleetId(String var1);

        public Builder aliasId(String var1);

        public Builder filterExpression(String var1);

        public Builder sortExpression(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

