/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfigurationNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMatchmakingConfigurationsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeMatchmakingConfigurationsRequest> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(DescribeMatchmakingConfigurationsRequest.getter(DescribeMatchmakingConfigurationsRequest::names)).setter(DescribeMatchmakingConfigurationsRequest.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetName").getter(DescribeMatchmakingConfigurationsRequest.getter(DescribeMatchmakingConfigurationsRequest::ruleSetName)).setter(DescribeMatchmakingConfigurationsRequest.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeMatchmakingConfigurationsRequest.getter(DescribeMatchmakingConfigurationsRequest::limit)).setter(DescribeMatchmakingConfigurationsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMatchmakingConfigurationsRequest.getter(DescribeMatchmakingConfigurationsRequest::nextToken)).setter(DescribeMatchmakingConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD, RULE_SET_NAME_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> names;
    private final String ruleSetName;
    private final Integer limit;
    private final String nextToken;

    private DescribeMatchmakingConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.names = builder.names;
        this.ruleSetName = builder.ruleSetName;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public List<String> names() {
        return this.names;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.names());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingConfigurationsRequest)) {
            return false;
        }
        DescribeMatchmakingConfigurationsRequest other = (DescribeMatchmakingConfigurationsRequest)((Object)obj);
        return Objects.equals(this.names(), other.names()) && Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMatchmakingConfigurationsRequest").add("Names", this.names()).add("RuleSetName", (Object)this.ruleSetName()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeMatchmakingConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String ruleSetName;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingConfigurationsRequest model) {
            super(model);
            this.names(model.names);
            this.ruleSetName(model.ruleSetName);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = MatchmakingConfigurationNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = MatchmakingConfigurationNameListCopier.copy(names);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMatchmakingConfigurationsRequest build() {
            return new DescribeMatchmakingConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMatchmakingConfigurationsRequest> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder ruleSetName(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

