/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.VpcPeeringConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcPeeringConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcPeeringConnection> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(VpcPeeringConnection.getter(VpcPeeringConnection::fleetId)).setter(VpcPeeringConnection.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(VpcPeeringConnection.getter(VpcPeeringConnection::fleetArn)).setter(VpcPeeringConnection.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> IP_V4_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpV4CidrBlock").getter(VpcPeeringConnection.getter(VpcPeeringConnection::ipV4CidrBlock)).setter(VpcPeeringConnection.setter(Builder::ipV4CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4CidrBlock").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringConnectionId").getter(VpcPeeringConnection.getter(VpcPeeringConnection::vpcPeeringConnectionId)).setter(VpcPeeringConnection.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").build()}).build();
    private static final SdkField<VpcPeeringConnectionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(VpcPeeringConnection.getter(VpcPeeringConnection::status)).setter(VpcPeeringConnection.setter(Builder::status)).constructor(VpcPeeringConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerVpcId").getter(VpcPeeringConnection.getter(VpcPeeringConnection::peerVpcId)).setter(VpcPeeringConnection.setter(Builder::peerVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()}).build();
    private static final SdkField<String> GAME_LIFT_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameLiftVpcId").getter(VpcPeeringConnection.getter(VpcPeeringConnection::gameLiftVpcId)).setter(VpcPeeringConnection.setter(Builder::gameLiftVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameLiftVpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, IP_V4_CIDR_BLOCK_FIELD, VPC_PEERING_CONNECTION_ID_FIELD, STATUS_FIELD, PEER_VPC_ID_FIELD, GAME_LIFT_VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String ipV4CidrBlock;
    private final String vpcPeeringConnectionId;
    private final VpcPeeringConnectionStatus status;
    private final String peerVpcId;
    private final String gameLiftVpcId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.ipV4CidrBlock = builder.ipV4CidrBlock;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
        this.status = builder.status;
        this.peerVpcId = builder.peerVpcId;
        this.gameLiftVpcId = builder.gameLiftVpcId;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String fleetArn() {
        return this.fleetArn;
    }

    public String ipV4CidrBlock() {
        return this.ipV4CidrBlock;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public VpcPeeringConnectionStatus status() {
        return this.status;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    public String gameLiftVpcId() {
        return this.gameLiftVpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipV4CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameLiftVpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.ipV4CidrBlock(), other.ipV4CidrBlock()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.peerVpcId(), other.peerVpcId()) && Objects.equals(this.gameLiftVpcId(), other.gameLiftVpcId());
    }

    public String toString() {
        return ToString.builder((String)"VpcPeeringConnection").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("IpV4CidrBlock", (Object)this.ipV4CidrBlock()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).add("Status", (Object)this.status()).add("PeerVpcId", (Object)this.peerVpcId()).add("GameLiftVpcId", (Object)this.gameLiftVpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "IpV4CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipV4CidrBlock()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PeerVpcId": {
                return Optional.ofNullable(clazz.cast(this.peerVpcId()));
            }
            case "GameLiftVpcId": {
                return Optional.ofNullable(clazz.cast(this.gameLiftVpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnection, T> g) {
        return obj -> g.apply((VpcPeeringConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String ipV4CidrBlock;
        private String vpcPeeringConnectionId;
        private VpcPeeringConnectionStatus status;
        private String peerVpcId;
        private String gameLiftVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.ipV4CidrBlock(model.ipV4CidrBlock);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
            this.status(model.status);
            this.peerVpcId(model.peerVpcId);
            this.gameLiftVpcId(model.gameLiftVpcId);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getIpV4CidrBlock() {
            return this.ipV4CidrBlock;
        }

        @Override
        public final Builder ipV4CidrBlock(String ipV4CidrBlock) {
            this.ipV4CidrBlock = ipV4CidrBlock;
            return this;
        }

        public final void setIpV4CidrBlock(String ipV4CidrBlock) {
            this.ipV4CidrBlock = ipV4CidrBlock;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        public final VpcPeeringConnectionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VpcPeeringConnectionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getGameLiftVpcId() {
            return this.gameLiftVpcId;
        }

        @Override
        public final Builder gameLiftVpcId(String gameLiftVpcId) {
            this.gameLiftVpcId = gameLiftVpcId;
            return this;
        }

        public final void setGameLiftVpcId(String gameLiftVpcId) {
            this.gameLiftVpcId = gameLiftVpcId;
        }

        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcPeeringConnection> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder ipV4CidrBlock(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder status(VpcPeeringConnectionStatus var1);

        default public Builder status(Consumer<VpcPeeringConnectionStatus.Builder> status) {
            return this.status((VpcPeeringConnectionStatus)((VpcPeeringConnectionStatus.Builder)VpcPeeringConnectionStatus.builder().applyMutation(status)).build());
        }

        public Builder peerVpcId(String var1);

        public Builder gameLiftVpcId(String var1);
    }
}

