/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.FleetUtilization;

public class DescribeFleetUtilizationIterable
implements SdkIterable<DescribeFleetUtilizationResponse> {
    private final GameLiftClient client;
    private final DescribeFleetUtilizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetUtilizationIterable(GameLiftClient client, DescribeFleetUtilizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFleetUtilizationResponseFetcher();
    }

    public Iterator<DescribeFleetUtilizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetUtilization> fleetUtilization() {
        Function<DescribeFleetUtilizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetUtilization() != null) {
                return response.fleetUtilization().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFleetUtilizationResponseFetcher
    implements SyncPageFetcher<DescribeFleetUtilizationResponse> {
        private DescribeFleetUtilizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetUtilizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetUtilizationResponse nextPage(DescribeFleetUtilizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetUtilizationIterable.this.client.describeFleetUtilization(DescribeFleetUtilizationIterable.this.firstRequest);
            }
            return DescribeFleetUtilizationIterable.this.client.describeFleetUtilization((DescribeFleetUtilizationRequest)((Object)DescribeFleetUtilizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

