/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueue;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGameSessionQueuesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
    private static final SdkField<List<GameSessionQueue>> GAME_SESSION_QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGameSessionQueuesResponse.getter(DescribeGameSessionQueuesResponse::gameSessionQueues)).setter(DescribeGameSessionQueuesResponse.setter(Builder::gameSessionQueues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameSessionQueue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGameSessionQueuesResponse.getter(DescribeGameSessionQueuesResponse::nextToken)).setter(DescribeGameSessionQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_QUEUES_FIELD, NEXT_TOKEN_FIELD));
    private final List<GameSessionQueue> gameSessionQueues;
    private final String nextToken;

    private DescribeGameSessionQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionQueues = builder.gameSessionQueues;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGameSessionQueues() {
        return this.gameSessionQueues != null && !(this.gameSessionQueues instanceof SdkAutoConstructList);
    }

    public List<GameSessionQueue> gameSessionQueues() {
        return this.gameSessionQueues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueues());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionQueuesResponse)) {
            return false;
        }
        DescribeGameSessionQueuesResponse other = (DescribeGameSessionQueuesResponse)((Object)obj);
        return Objects.equals(this.gameSessionQueues(), other.gameSessionQueues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGameSessionQueuesResponse").add("GameSessionQueues", this.gameSessionQueues()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionQueues": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameSessionQueuesResponse, T> g) {
        return obj -> g.apply((DescribeGameSessionQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameSessionQueue> gameSessionQueues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionQueuesResponse model) {
            super(model);
            this.gameSessionQueues(model.gameSessionQueues);
            this.nextToken(model.nextToken);
        }

        public final Collection<GameSessionQueue.Builder> getGameSessionQueues() {
            return this.gameSessionQueues != null ? (Collection)this.gameSessionQueues.stream().map(GameSessionQueue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameSessionQueues(Collection<GameSessionQueue> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copy(gameSessionQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(GameSessionQueue ... gameSessionQueues) {
            this.gameSessionQueues(Arrays.asList(gameSessionQueues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(Consumer<GameSessionQueue.Builder> ... gameSessionQueues) {
            this.gameSessionQueues(Stream.of(gameSessionQueues).map(c -> (GameSessionQueue)((GameSessionQueue.Builder)GameSessionQueue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameSessionQueues(Collection<GameSessionQueue.BuilderImpl> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copyFromBuilder(gameSessionQueues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeGameSessionQueuesResponse build() {
            return new DescribeGameSessionQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
        public Builder gameSessionQueues(Collection<GameSessionQueue> var1);

        public Builder gameSessionQueues(GameSessionQueue ... var1);

        public Builder gameSessionQueues(Consumer<GameSessionQueue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

