/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.CertificateConfiguration;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.FleetAction;
import software.amazon.awssdk.services.gamelift.model.FleetActionListCopier;
import software.amazon.awssdk.services.gamelift.model.FleetStatus;
import software.amazon.awssdk.services.gamelift.model.FleetType;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetAttributes> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::fleetId)).setter(FleetAttributes.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::fleetArn)).setter(FleetAttributes.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::fleetTypeAsString)).setter(FleetAttributes.setter(Builder::fleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::instanceTypeAsString)).setter(FleetAttributes.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::description)).setter(FleetAttributes.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::name)).setter(FleetAttributes.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetAttributes.getter(FleetAttributes::creationTime)).setter(FleetAttributes.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TERMINATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetAttributes.getter(FleetAttributes::terminationTime)).setter(FleetAttributes.setter(Builder::terminationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::statusAsString)).setter(FleetAttributes.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> BUILD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::buildId)).setter(FleetAttributes.setter(Builder::buildId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()}).build();
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::scriptId)).setter(FleetAttributes.setter(Builder::scriptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()}).build();
    private static final SdkField<String> SERVER_LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::serverLaunchPath)).setter(FleetAttributes.setter(Builder::serverLaunchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchPath").build()}).build();
    private static final SdkField<String> SERVER_LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::serverLaunchParameters)).setter(FleetAttributes.setter(Builder::serverLaunchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchParameters").build()}).build();
    private static final SdkField<List<String>> LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetAttributes.getter(FleetAttributes::logPaths)).setter(FleetAttributes.setter(Builder::logPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::newGameSessionProtectionPolicyAsString)).setter(FleetAttributes.setter(Builder::newGameSessionProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::operatingSystemAsString)).setter(FleetAttributes.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FleetAttributes.getter(FleetAttributes::resourceCreationLimitPolicy)).setter(FleetAttributes.setter(Builder::resourceCreationLimitPolicy)).constructor(ResourceCreationLimitPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy").build()}).build();
    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetAttributes.getter(FleetAttributes::metricGroups)).setter(FleetAttributes.setter(Builder::metricGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STOPPED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FleetAttributes.getter(FleetAttributes::stoppedActionsAsStrings)).setter(FleetAttributes.setter(Builder::stoppedActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetAttributes.getter(FleetAttributes::instanceRoleArn)).setter(FleetAttributes.setter(Builder::instanceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()}).build();
    private static final SdkField<CertificateConfiguration> CERTIFICATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FleetAttributes.getter(FleetAttributes::certificateConfiguration)).setter(FleetAttributes.setter(Builder::certificateConfiguration)).constructor(CertificateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, FLEET_TYPE_FIELD, INSTANCE_TYPE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CREATION_TIME_FIELD, TERMINATION_TIME_FIELD, STATUS_FIELD, BUILD_ID_FIELD, SCRIPT_ID_FIELD, SERVER_LAUNCH_PATH_FIELD, SERVER_LAUNCH_PARAMETERS_FIELD, LOG_PATHS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, OPERATING_SYSTEM_FIELD, RESOURCE_CREATION_LIMIT_POLICY_FIELD, METRIC_GROUPS_FIELD, STOPPED_ACTIONS_FIELD, INSTANCE_ROLE_ARN_FIELD, CERTIFICATE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String fleetType;
    private final String instanceType;
    private final String description;
    private final String name;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final String status;
    private final String buildId;
    private final String scriptId;
    private final String serverLaunchPath;
    private final String serverLaunchParameters;
    private final List<String> logPaths;
    private final String newGameSessionProtectionPolicy;
    private final String operatingSystem;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;
    private final List<String> stoppedActions;
    private final String instanceRoleArn;
    private final CertificateConfiguration certificateConfiguration;

    private FleetAttributes(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.fleetType = builder.fleetType;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.buildId = builder.buildId;
        this.scriptId = builder.scriptId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.operatingSystem = builder.operatingSystem;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.stoppedActions = builder.stoppedActions;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.certificateConfiguration = builder.certificateConfiguration;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String fleetArn() {
        return this.fleetArn;
    }

    public FleetType fleetType() {
        return FleetType.fromValue(this.fleetType);
    }

    public String fleetTypeAsString() {
        return this.fleetType;
    }

    public EC2InstanceType instanceType() {
        return EC2InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant terminationTime() {
        return this.terminationTime;
    }

    public FleetStatus status() {
        return FleetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String buildId() {
        return this.buildId;
    }

    public String scriptId() {
        return this.scriptId;
    }

    public String serverLaunchPath() {
        return this.serverLaunchPath;
    }

    public String serverLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public List<String> logPaths() {
        return this.logPaths;
    }

    public ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public String newGameSessionProtectionPolicyAsString() {
        return this.newGameSessionProtectionPolicy;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public List<String> metricGroups() {
        return this.metricGroups;
    }

    public List<FleetAction> stoppedActions() {
        return FleetActionListCopier.copyStringToEnum(this.stoppedActions);
    }

    public List<String> stoppedActionsAsStrings() {
        return this.stoppedActions;
    }

    public String instanceRoleArn() {
        return this.instanceRoleArn;
    }

    public CertificateConfiguration certificateConfiguration() {
        return this.certificateConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedActionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAttributes)) {
            return false;
        }
        FleetAttributes other = (FleetAttributes)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.fleetTypeAsString(), other.fleetTypeAsString()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationTime(), other.terminationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.scriptId(), other.scriptId()) && Objects.equals(this.serverLaunchPath(), other.serverLaunchPath()) && Objects.equals(this.serverLaunchParameters(), other.serverLaunchParameters()) && Objects.equals(this.logPaths(), other.logPaths()) && Objects.equals(this.newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy()) && Objects.equals(this.metricGroups(), other.metricGroups()) && Objects.equals(this.stoppedActionsAsStrings(), other.stoppedActionsAsStrings()) && Objects.equals(this.instanceRoleArn(), other.instanceRoleArn()) && Objects.equals(this.certificateConfiguration(), other.certificateConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"FleetAttributes").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("FleetType", (Object)this.fleetTypeAsString()).add("InstanceType", (Object)this.instanceTypeAsString()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("CreationTime", (Object)this.creationTime()).add("TerminationTime", (Object)this.terminationTime()).add("Status", (Object)this.statusAsString()).add("BuildId", (Object)this.buildId()).add("ScriptId", (Object)this.scriptId()).add("ServerLaunchPath", (Object)this.serverLaunchPath()).add("ServerLaunchParameters", (Object)this.serverLaunchParameters()).add("LogPaths", this.logPaths()).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyAsString()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("ResourceCreationLimitPolicy", (Object)this.resourceCreationLimitPolicy()).add("MetricGroups", this.metricGroups()).add("StoppedActions", this.stoppedActionsAsStrings()).add("InstanceRoleArn", (Object)this.instanceRoleArn()).add("CertificateConfiguration", (Object)this.certificateConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "FleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetTypeAsString()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.ofNullable(clazz.cast(this.terminationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "BuildId": {
                return Optional.ofNullable(clazz.cast(this.buildId()));
            }
            case "ScriptId": {
                return Optional.ofNullable(clazz.cast(this.scriptId()));
            }
            case "ServerLaunchPath": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchPath()));
            }
            case "ServerLaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchParameters()));
            }
            case "LogPaths": {
                return Optional.ofNullable(clazz.cast(this.logPaths()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.newGameSessionProtectionPolicyAsString()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "ResourceCreationLimitPolicy": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationLimitPolicy()));
            }
            case "MetricGroups": {
                return Optional.ofNullable(clazz.cast(this.metricGroups()));
            }
            case "StoppedActions": {
                return Optional.ofNullable(clazz.cast(this.stoppedActionsAsStrings()));
            }
            case "InstanceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleArn()));
            }
            case "CertificateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.certificateConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetAttributes, T> g) {
        return obj -> g.apply((FleetAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String fleetType;
        private String instanceType;
        private String description;
        private String name;
        private Instant creationTime;
        private Instant terminationTime;
        private String status;
        private String buildId;
        private String scriptId;
        private String serverLaunchPath;
        private String serverLaunchParameters;
        private List<String> logPaths = DefaultSdkAutoConstructList.getInstance();
        private String newGameSessionProtectionPolicy;
        private String operatingSystem;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> stoppedActions = DefaultSdkAutoConstructList.getInstance();
        private String instanceRoleArn;
        private CertificateConfiguration certificateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAttributes model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.fleetType(model.fleetType);
            this.instanceType(model.instanceType);
            this.description(model.description);
            this.name(model.name);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.status(model.status);
            this.buildId(model.buildId);
            this.scriptId(model.scriptId);
            this.serverLaunchPath(model.serverLaunchPath);
            this.serverLaunchParameters(model.serverLaunchParameters);
            this.logPaths(model.logPaths);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.operatingSystem(model.operatingSystem);
            this.resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.metricGroups(model.metricGroups);
            this.stoppedActionsWithStrings(model.stoppedActions);
            this.instanceRoleArn(model.instanceRoleArn);
            this.certificateConfiguration(model.certificateConfiguration);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getFleetTypeAsString() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getInstanceTypeAsString() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(EC2InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        public final String getScriptId() {
            return this.scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        public final String getServerLaunchPath() {
            return this.serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        public final String getServerLaunchParameters() {
            return this.serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        public final Collection<String> getLogPaths() {
            return this.logPaths;
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String ... logPaths) {
            this.logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        public final String getNewGameSessionProtectionPolicyAsString() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final String getOperatingSystemAsString() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy != null ? this.resourceCreationLimitPolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        public final Collection<String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        public final Collection<String> getStoppedActionsAsStrings() {
            return this.stoppedActions;
        }

        @Override
        public final Builder stoppedActionsWithStrings(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppedActionsWithStrings(String ... stoppedActions) {
            this.stoppedActionsWithStrings(Arrays.asList(stoppedActions));
            return this;
        }

        @Override
        public final Builder stoppedActions(Collection<FleetAction> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copyEnumToString(stoppedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppedActions(FleetAction ... stoppedActions) {
            this.stoppedActions(Arrays.asList(stoppedActions));
            return this;
        }

        public final void setStoppedActionsWithStrings(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
        }

        public final String getInstanceRoleArn() {
            return this.instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        public final CertificateConfiguration.Builder getCertificateConfiguration() {
            return this.certificateConfiguration != null ? this.certificateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder certificateConfiguration(CertificateConfiguration certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        public final void setCertificateConfiguration(CertificateConfiguration.BuilderImpl certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration != null ? certificateConfiguration.build() : null;
        }

        public FleetAttributes build() {
            return new FleetAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetAttributes> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder fleetType(String var1);

        public Builder fleetType(FleetType var1);

        public Builder instanceType(String var1);

        public Builder instanceType(EC2InstanceType var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(FleetStatus var1);

        public Builder buildId(String var1);

        public Builder scriptId(String var1);

        public Builder serverLaunchPath(String var1);

        public Builder serverLaunchParameters(String var1);

        public Builder logPaths(Collection<String> var1);

        public Builder logPaths(String ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        default public Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return this.resourceCreationLimitPolicy((ResourceCreationLimitPolicy)((ResourceCreationLimitPolicy.Builder)ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)).build());
        }

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder stoppedActionsWithStrings(Collection<String> var1);

        public Builder stoppedActionsWithStrings(String ... var1);

        public Builder stoppedActions(Collection<FleetAction> var1);

        public Builder stoppedActions(FleetAction ... var1);

        public Builder instanceRoleArn(String var1);

        public Builder certificateConfiguration(CertificateConfiguration var1);

        default public Builder certificateConfiguration(Consumer<CertificateConfiguration.Builder> certificateConfiguration) {
            return this.certificateConfiguration((CertificateConfiguration)((CertificateConfiguration.Builder)CertificateConfiguration.builder().applyMutation(certificateConfiguration)).build());
        }
    }
}

