/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetPortSettingsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
    private static final SdkField<List<IpPermission>> INBOUND_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeFleetPortSettingsResponse.getter(DescribeFleetPortSettingsResponse::inboundPermissions)).setter(DescribeFleetPortSettingsResponse.setter(Builder::inboundPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOUND_PERMISSIONS_FIELD));
    private final List<IpPermission> inboundPermissions;

    private DescribeFleetPortSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.inboundPermissions = builder.inboundPermissions;
    }

    public List<IpPermission> inboundPermissions() {
        return this.inboundPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundPermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetPortSettingsResponse)) {
            return false;
        }
        DescribeFleetPortSettingsResponse other = (DescribeFleetPortSettingsResponse)((Object)obj);
        return Objects.equals(this.inboundPermissions(), other.inboundPermissions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetPortSettingsResponse").add("InboundPermissions", this.inboundPermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InboundPermissions": {
                return Optional.ofNullable(clazz.cast(this.inboundPermissions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetPortSettingsResponse, T> g) {
        return obj -> g.apply((DescribeFleetPortSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<IpPermission> inboundPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetPortSettingsResponse model) {
            super(model);
            this.inboundPermissions(model.inboundPermissions);
        }

        public final Collection<IpPermission.Builder> getInboundPermissions() {
            return this.inboundPermissions != null ? (Collection)this.inboundPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissions(Collection<IpPermission> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copy(inboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(IpPermission ... inboundPermissions) {
            this.inboundPermissions(Arrays.asList(inboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissions(Consumer<IpPermission.Builder> ... inboundPermissions) {
            this.inboundPermissions(Stream.of(inboundPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInboundPermissions(Collection<IpPermission.BuilderImpl> inboundPermissions) {
            this.inboundPermissions = IpPermissionsListCopier.copyFromBuilder(inboundPermissions);
        }

        @Override
        public DescribeFleetPortSettingsResponse build() {
            return new DescribeFleetPortSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetPortSettingsResponse> {
        public Builder inboundPermissions(Collection<IpPermission> var1);

        public Builder inboundPermissions(IpPermission ... var1);

        public Builder inboundPermissions(Consumer<IpPermission.Builder> ... var1);
    }
}

