/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.GameSessionStatus;
import software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameSession> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::gameSessionId)).setter(GameSession.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::name)).setter(GameSession.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::fleetId)).setter(GameSession.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GameSession.getter(GameSession::creationTime)).setter(GameSession.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TERMINATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GameSession.getter(GameSession::terminationTime)).setter(GameSession.setter(Builder::terminationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationTime").build()}).build();
    private static final SdkField<Integer> CURRENT_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GameSession.getter(GameSession::currentPlayerSessionCount)).setter(GameSession.setter(Builder::currentPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPlayerSessionCount").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GameSession.getter(GameSession::maximumPlayerSessionCount)).setter(GameSession.setter(Builder::maximumPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::statusAsString)).setter(GameSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::statusReasonAsString)).setter(GameSession.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GameSession.getter(GameSession::gameProperties)).setter(GameSession.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::ipAddress)).setter(GameSession.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GameSession.getter(GameSession::port)).setter(GameSession.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> PLAYER_SESSION_CREATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::playerSessionCreationPolicyAsString)).setter(GameSession.setter(Builder::playerSessionCreationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionCreationPolicy").build()}).build();
    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::creatorId)).setter(GameSession.setter(Builder::creatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()}).build();
    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::gameSessionData)).setter(GameSession.setter(Builder::gameSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()}).build();
    private static final SdkField<String> MATCHMAKER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GameSession.getter(GameSession::matchmakerData)).setter(GameSession.setter(Builder::matchmakerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchmakerData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD, NAME_FIELD, FLEET_ID_FIELD, CREATION_TIME_FIELD, TERMINATION_TIME_FIELD, CURRENT_PLAYER_SESSION_COUNT_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, GAME_PROPERTIES_FIELD, IP_ADDRESS_FIELD, PORT_FIELD, PLAYER_SESSION_CREATION_POLICY_FIELD, CREATOR_ID_FIELD, GAME_SESSION_DATA_FIELD, MATCHMAKER_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gameSessionId;
    private final String name;
    private final String fleetId;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final Integer currentPlayerSessionCount;
    private final Integer maximumPlayerSessionCount;
    private final String status;
    private final String statusReason;
    private final List<GameProperty> gameProperties;
    private final String ipAddress;
    private final Integer port;
    private final String playerSessionCreationPolicy;
    private final String creatorId;
    private final String gameSessionData;
    private final String matchmakerData;

    private GameSession(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.name = builder.name;
        this.fleetId = builder.fleetId;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.gameProperties = builder.gameProperties;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.creatorId = builder.creatorId;
        this.gameSessionData = builder.gameSessionData;
        this.matchmakerData = builder.matchmakerData;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String name() {
        return this.name;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant terminationTime() {
        return this.terminationTime;
    }

    public Integer currentPlayerSessionCount() {
        return this.currentPlayerSessionCount;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public GameSessionStatus status() {
        return GameSessionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public GameSessionStatusReason statusReason() {
        return GameSessionStatusReason.fromValue(this.statusReason);
    }

    public String statusReasonAsString() {
        return this.statusReason;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public PlayerSessionCreationPolicy playerSessionCreationPolicy() {
        return PlayerSessionCreationPolicy.fromValue(this.playerSessionCreationPolicy);
    }

    public String playerSessionCreationPolicyAsString() {
        return this.playerSessionCreationPolicy;
    }

    public String creatorId() {
        return this.creatorId;
    }

    public String gameSessionData() {
        return this.gameSessionData;
    }

    public String matchmakerData() {
        return this.matchmakerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionCreationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchmakerData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSession)) {
            return false;
        }
        GameSession other = (GameSession)obj;
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationTime(), other.terminationTime()) && Objects.equals(this.currentPlayerSessionCount(), other.currentPlayerSessionCount()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.playerSessionCreationPolicyAsString(), other.playerSessionCreationPolicyAsString()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.gameSessionData(), other.gameSessionData()) && Objects.equals(this.matchmakerData(), other.matchmakerData());
    }

    public String toString() {
        return ToString.builder((String)"GameSession").add("GameSessionId", (Object)this.gameSessionId()).add("Name", (Object)this.name()).add("FleetId", (Object)this.fleetId()).add("CreationTime", (Object)this.creationTime()).add("TerminationTime", (Object)this.terminationTime()).add("CurrentPlayerSessionCount", (Object)this.currentPlayerSessionCount()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("GameProperties", this.gameProperties()).add("IpAddress", (Object)this.ipAddress()).add("Port", (Object)this.port()).add("PlayerSessionCreationPolicy", (Object)this.playerSessionCreationPolicyAsString()).add("CreatorId", (Object)this.creatorId()).add("GameSessionData", (Object)this.gameSessionData()).add("MatchmakerData", (Object)this.matchmakerData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.ofNullable(clazz.cast(this.terminationTime()));
            }
            case "CurrentPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.currentPlayerSessionCount()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "PlayerSessionCreationPolicy": {
                return Optional.ofNullable(clazz.cast(this.playerSessionCreationPolicyAsString()));
            }
            case "CreatorId": {
                return Optional.ofNullable(clazz.cast(this.creatorId()));
            }
            case "GameSessionData": {
                return Optional.ofNullable(clazz.cast(this.gameSessionData()));
            }
            case "MatchmakerData": {
                return Optional.ofNullable(clazz.cast(this.matchmakerData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameSession, T> g) {
        return obj -> g.apply((GameSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String name;
        private String fleetId;
        private Instant creationTime;
        private Instant terminationTime;
        private Integer currentPlayerSessionCount;
        private Integer maximumPlayerSessionCount;
        private String status;
        private String statusReason;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();
        private String ipAddress;
        private Integer port;
        private String playerSessionCreationPolicy;
        private String creatorId;
        private String gameSessionData;
        private String matchmakerData;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSession model) {
            this.gameSessionId(model.gameSessionId);
            this.name(model.name);
            this.fleetId(model.fleetId);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.currentPlayerSessionCount(model.currentPlayerSessionCount);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.gameProperties(model.gameProperties);
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.playerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.creatorId(model.creatorId);
            this.gameSessionData(model.gameSessionData);
            this.matchmakerData(model.matchmakerData);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return this.currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GameSessionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(GameSessionStatusReason statusReason) {
            this.statusReason(statusReason.toString());
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
            return this;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        public final String getMatchmakerData() {
            return this.matchmakerData;
        }

        @Override
        public final Builder matchmakerData(String matchmakerData) {
            this.matchmakerData = matchmakerData;
            return this;
        }

        public final void setMatchmakerData(String matchmakerData) {
            this.matchmakerData = matchmakerData;
        }

        public GameSession build() {
            return new GameSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameSession> {
        public Builder gameSessionId(String var1);

        public Builder name(String var1);

        public Builder fleetId(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder currentPlayerSessionCount(Integer var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder status(String var1);

        public Builder status(GameSessionStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(GameSessionStatusReason var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder creatorId(String var1);

        public Builder gameSessionData(String var1);

        public Builder matchmakerData(String var1);
    }
}

