/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;

@SdkInternalApi
public class PlayerLatencyMarshaller {
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").build();
    private static final MarshallingInfo<String> REGIONIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegionIdentifier").build();
    private static final MarshallingInfo<Float> LATENCYINMILLISECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatencyInMilliseconds").build();
    private static final PlayerLatencyMarshaller INSTANCE = new PlayerLatencyMarshaller();

    public static PlayerLatencyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PlayerLatency playerLatency, ProtocolMarshaller protocolMarshaller) {
        if (playerLatency == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)playerLatency.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall((Object)playerLatency.regionIdentifier(), REGIONIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)playerLatency.latencyInMilliseconds(), LATENCYINMILLISECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

