/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.AttributeValue;

@SdkInternalApi
public class AttributeValueMarshaller {
    private static final MarshallingInfo<String> S_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S").build();
    private static final MarshallingInfo<Double> N_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("N").build();
    private static final MarshallingInfo<List> SL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SL").build();
    private static final MarshallingInfo<Map> SDM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SDM").build();
    private static final AttributeValueMarshaller INSTANCE = new AttributeValueMarshaller();

    public static AttributeValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttributeValue attributeValue, ProtocolMarshaller protocolMarshaller) {
        if (attributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attributeValue.s(), S_BINDING);
            protocolMarshaller.marshall((Object)attributeValue.n(), N_BINDING);
            protocolMarshaller.marshall(attributeValue.sl(), SL_BINDING);
            protocolMarshaller.marshall(attributeValue.sdm(), SDM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

