/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus;
import software.amazon.awssdk.services.gamelift.transform.PlayerSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlayerSession
implements StructuredPojo,
ToCopyableBuilder<Builder, PlayerSession> {
    private final String playerSessionId;
    private final String playerId;
    private final String gameSessionId;
    private final String fleetId;
    private final Instant creationTime;
    private final Instant terminationTime;
    private final String status;
    private final String ipAddress;
    private final Integer port;
    private final String playerData;

    private PlayerSession(BuilderImpl builder) {
        this.playerSessionId = builder.playerSessionId;
        this.playerId = builder.playerId;
        this.gameSessionId = builder.gameSessionId;
        this.fleetId = builder.fleetId;
        this.creationTime = builder.creationTime;
        this.terminationTime = builder.terminationTime;
        this.status = builder.status;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.playerData = builder.playerData;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant terminationTime() {
        return this.terminationTime;
    }

    public PlayerSessionStatus status() {
        return PlayerSessionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerSession)) {
            return false;
        }
        PlayerSession other = (PlayerSession)obj;
        return Objects.equals(this.playerSessionId(), other.playerSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationTime(), other.terminationTime()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.playerData(), other.playerData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.playerSessionId() != null) {
            sb.append("PlayerSessionId: ").append(this.playerSessionId()).append(",");
        }
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.terminationTime() != null) {
            sb.append("TerminationTime: ").append(this.terminationTime()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.playerData() != null) {
            sb.append("PlayerData: ").append(this.playerData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerSessionId": {
                return Optional.of(clazz.cast(this.playerSessionId()));
            }
            case "PlayerId": {
                return Optional.of(clazz.cast(this.playerId()));
            }
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "TerminationTime": {
                return Optional.of(clazz.cast(this.terminationTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "PlayerData": {
                return Optional.of(clazz.cast(this.playerData()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerSessionId;
        private String playerId;
        private String gameSessionId;
        private String fleetId;
        private Instant creationTime;
        private Instant terminationTime;
        private String status;
        private String ipAddress;
        private Integer port;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerSession model) {
            this.playerSessionId(model.playerSessionId);
            this.playerId(model.playerId);
            this.gameSessionId(model.gameSessionId);
            this.fleetId(model.fleetId);
            this.creationTime(model.creationTime);
            this.terminationTime(model.terminationTime);
            this.status(model.status);
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.playerData(model.playerData);
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTerminationTime() {
            return this.terminationTime;
        }

        @Override
        public final Builder terminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public final void setTerminationTime(Instant terminationTime) {
            this.terminationTime = terminationTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PlayerSessionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        public PlayerSession build() {
            return new PlayerSession(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlayerSession> {
        public Builder playerSessionId(String var1);

        public Builder playerId(String var1);

        public Builder gameSessionId(String var1);

        public Builder fleetId(String var1);

        public Builder creationTime(Instant var1);

        public Builder terminationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(PlayerSessionStatus var1);

        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder playerData(String var1);
    }
}

