/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.InstanceCredentials;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.transform.InstanceAccessMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAccess
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAccess> {
    private final String fleetId;
    private final String instanceId;
    private final String ipAddress;
    private final String operatingSystem;
    private final InstanceCredentials credentials;

    private InstanceAccess(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.instanceId = builder.instanceId;
        this.ipAddress = builder.ipAddress;
        this.operatingSystem = builder.operatingSystem;
        this.credentials = builder.credentials;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    public InstanceCredentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccess)) {
            return false;
        }
        InstanceAccess other = (InstanceAccess)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.operatingSystemString(), other.operatingSystemString()) && Objects.equals(this.credentials(), other.credentials());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.operatingSystemString() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystemString()).append(",");
        }
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAccessMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String instanceId;
        private String ipAddress;
        private String operatingSystem;
        private InstanceCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccess model) {
            this.fleetId(model.fleetId);
            this.instanceId(model.instanceId);
            this.ipAddress(model.ipAddress);
            this.operatingSystem(model.operatingSystem);
            this.credentials(model.credentials);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final InstanceCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(InstanceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(InstanceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public InstanceAccess build() {
            return new InstanceAccess(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAccess> {
        public Builder fleetId(String var1);

        public Builder instanceId(String var1);

        public Builder ipAddress(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder credentials(InstanceCredentials var1);

        default public Builder credentials(Consumer<InstanceCredentials.Builder> credentials) {
            return this.credentials((InstanceCredentials)((InstanceCredentials.Builder)InstanceCredentials.builder().apply(credentials)).build());
        }
    }
}

