/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.InstanceStatus;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements StructuredPojo,
ToCopyableBuilder<Builder, Instance> {
    private final String fleetId;
    private final String instanceId;
    private final String ipAddress;
    private final String operatingSystem;
    private final String type;
    private final String status;
    private final Instant creationTime;

    private Instance(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.instanceId = builder.instanceId;
        this.ipAddress = builder.ipAddress;
        this.operatingSystem = builder.operatingSystem;
        this.type = builder.type;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    public EC2InstanceType type() {
        return EC2InstanceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public InstanceStatus status() {
        return InstanceStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.operatingSystemString(), other.operatingSystemString()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.operatingSystemString() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystemString()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String instanceId;
        private String ipAddress;
        private String operatingSystem;
        private String type;
        private String status;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.fleetId(model.fleetId);
            this.instanceId(model.instanceId);
            this.ipAddress(model.ipAddress);
            this.operatingSystem(model.operatingSystem);
            this.type(model.type);
            this.status(model.status);
            this.creationTime(model.creationTime);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EC2InstanceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder fleetId(String var1);

        public Builder instanceId(String var1);

        public Builder ipAddress(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder type(String var1);

        public Builder type(EC2InstanceType var1);

        public Builder status(String var1);

        public Builder status(InstanceStatus var1);

        public Builder creationTime(Instant var1);
    }
}

