/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeInstancesRequest> {
    private final String fleetId;
    private final String instanceId;
    private final Integer limit;
    private final String nextToken;

    private DescribeInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.instanceId = builder.instanceId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String instanceId;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesRequest model) {
            this.fleetId(model.fleetId);
            this.instanceId(model.instanceId);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancesRequest build() {
            return new DescribeInstancesRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DescribeInstancesRequest> {
        public Builder fleetId(String var1);

        public Builder instanceId(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

