/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEC2InstanceLimitsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeEC2InstanceLimitsRequest> {
    private final String ec2InstanceType;

    private DescribeEC2InstanceLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceType = builder.ec2InstanceType;
    }

    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public String ec2InstanceTypeString() {
        return this.ec2InstanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEC2InstanceLimitsRequest)) {
            return false;
        }
        DescribeEC2InstanceLimitsRequest other = (DescribeEC2InstanceLimitsRequest)((Object)obj);
        return Objects.equals(this.ec2InstanceTypeString(), other.ec2InstanceTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ec2InstanceTypeString() != null) {
            sb.append("EC2InstanceType: ").append(this.ec2InstanceTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceType": {
                return Optional.of(clazz.cast(this.ec2InstanceTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String ec2InstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEC2InstanceLimitsRequest model) {
            this.ec2InstanceType(model.ec2InstanceType);
        }

        public final String getEC2InstanceType() {
            return this.ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType.toString());
            return this;
        }

        public final void setEC2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEC2InstanceLimitsRequest build() {
            return new DescribeEC2InstanceLimitsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DescribeEC2InstanceLimitsRequest> {
        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

