/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.StringDoubleMapCopier;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.services.gamelift.transform.AttributeValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeValue> {
    private final String s;
    private final Double n;
    private final List<String> sl;
    private final Map<String, Double> sdm;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.sl = builder.sl;
        this.sdm = builder.sdm;
    }

    public String s() {
        return this.s;
    }

    public Double n() {
        return this.n;
    }

    public List<String> sl() {
        return this.sl;
    }

    public Map<String, Double> sdm() {
        return this.sdm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.sl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdm());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.sl(), other.sl()) && Objects.equals(this.sdm(), other.sdm());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.s() != null) {
            sb.append("S: ").append(this.s()).append(",");
        }
        if (this.n() != null) {
            sb.append("N: ").append(this.n()).append(",");
        }
        if (this.sl() != null) {
            sb.append("SL: ").append(this.sl()).append(",");
        }
        if (this.sdm() != null) {
            sb.append("SDM: ").append(this.sdm()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.of(clazz.cast(this.s()));
            }
            case "N": {
                return Optional.of(clazz.cast(this.n()));
            }
            case "SL": {
                return Optional.of(clazz.cast(this.sl()));
            }
            case "SDM": {
                return Optional.of(clazz.cast(this.sdm()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private Double n;
        private List<String> sl;
        private Map<String, Double> sdm;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.s(model.s);
            this.n(model.n);
            this.sl(model.sl);
            this.sdm(model.sdm);
        }

        public final String getS() {
            return this.s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final void setS(String s) {
            this.s = s;
        }

        public final Double getN() {
            return this.n;
        }

        @Override
        public final Builder n(Double n) {
            this.n = n;
            return this;
        }

        public final void setN(Double n) {
            this.n = n;
        }

        public final Collection<String> getSL() {
            return this.sl;
        }

        @Override
        public final Builder sl(Collection<String> sl) {
            this.sl = StringListCopier.copy(sl);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sl(String ... sl) {
            this.sl(Arrays.asList(sl));
            return this;
        }

        public final void setSL(Collection<String> sl) {
            this.sl = StringListCopier.copy(sl);
        }

        public final Map<String, Double> getSDM() {
            return this.sdm;
        }

        @Override
        public final Builder sdm(Map<String, Double> sdm) {
            this.sdm = StringDoubleMapCopier.copy(sdm);
            return this;
        }

        public final void setSDM(Map<String, Double> sdm) {
            this.sdm = StringDoubleMapCopier.copy(sdm);
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(Double var1);

        public Builder sl(Collection<String> var1);

        public Builder sl(String ... var1);

        public Builder sdm(Map<String, Double> var1);
    }
}

