/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.RoutingStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAliasRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateAliasRequest> {
    private final String aliasId;
    private final String name;
    private final String description;
    private final RoutingStrategy routingStrategy;

    private UpdateAliasRequest(BuilderImpl builder) {
        this.aliasId = builder.aliasId;
        this.name = builder.name;
        this.description = builder.description;
        this.routingStrategy = builder.routingStrategy;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public RoutingStrategy routingStrategy() {
        return this.routingStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingStrategy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAliasRequest)) {
            return false;
        }
        UpdateAliasRequest other = (UpdateAliasRequest)((Object)obj);
        return Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingStrategy(), other.routingStrategy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.aliasId() != null) {
            sb.append("AliasId: ").append(this.aliasId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.routingStrategy() != null) {
            sb.append("RoutingStrategy: ").append(this.routingStrategy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasId": {
                return Optional.of(clazz.cast(this.aliasId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "RoutingStrategy": {
                return Optional.of(clazz.cast(this.routingStrategy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasId;
        private String name;
        private String description;
        private RoutingStrategy routingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAliasRequest model) {
            this.aliasId(model.aliasId);
            this.name(model.name);
            this.description(model.description);
            this.routingStrategy(model.routingStrategy);
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final RoutingStrategy.Builder getRoutingStrategy() {
            return this.routingStrategy != null ? this.routingStrategy.toBuilder() : null;
        }

        @Override
        public final Builder routingStrategy(RoutingStrategy routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        public final void setRoutingStrategy(RoutingStrategy.BuilderImpl routingStrategy) {
            this.routingStrategy = routingStrategy != null ? routingStrategy.build() : null;
        }

        public UpdateAliasRequest build() {
            return new UpdateAliasRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAliasRequest> {
        public Builder aliasId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder routingStrategy(RoutingStrategy var1);

        default public Builder routingStrategy(Consumer<RoutingStrategy.Builder> routingStrategy) {
            return this.routingStrategy((RoutingStrategy)((RoutingStrategy.Builder)RoutingStrategy.builder().apply(routingStrategy)).build());
        }
    }
}

