/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchGameSessionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SearchGameSessionsRequest> {
    private final String fleetId;
    private final String aliasId;
    private final String filterExpression;
    private final String sortExpression;
    private final Integer limit;
    private final String nextToken;

    private SearchGameSessionsRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.filterExpression = builder.filterExpression;
        this.sortExpression = builder.sortExpression;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public String sortExpression() {
        return this.sortExpression;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGameSessionsRequest)) {
            return false;
        }
        SearchGameSessionsRequest other = (SearchGameSessionsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.sortExpression(), other.sortExpression()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.aliasId() != null) {
            sb.append("AliasId: ").append(this.aliasId()).append(",");
        }
        if (this.filterExpression() != null) {
            sb.append("FilterExpression: ").append(this.filterExpression()).append(",");
        }
        if (this.sortExpression() != null) {
            sb.append("SortExpression: ").append(this.sortExpression()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "AliasId": {
                return Optional.of(clazz.cast(this.aliasId()));
            }
            case "FilterExpression": {
                return Optional.of(clazz.cast(this.filterExpression()));
            }
            case "SortExpression": {
                return Optional.of(clazz.cast(this.sortExpression()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String aliasId;
        private String filterExpression;
        private String sortExpression;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGameSessionsRequest model) {
            this.fleetId(model.fleetId);
            this.aliasId(model.aliasId);
            this.filterExpression(model.filterExpression);
            this.sortExpression(model.sortExpression);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getSortExpression() {
            return this.sortExpression;
        }

        @Override
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public SearchGameSessionsRequest build() {
            return new SearchGameSessionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchGameSessionsRequest> {
        public Builder fleetId(String var1);

        public Builder aliasId(String var1);

        public Builder filterExpression(String var1);

        public Builder sortExpression(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

