/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.ServerProcess;
import software.amazon.awssdk.services.gamelift.model.ServerProcessListCopier;
import software.amazon.awssdk.services.gamelift.transform.RuntimeConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RuntimeConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, RuntimeConfiguration> {
    private final List<ServerProcess> serverProcesses;
    private final Integer maxConcurrentGameSessionActivations;
    private final Integer gameSessionActivationTimeoutSeconds;

    private RuntimeConfiguration(BuilderImpl builder) {
        this.serverProcesses = builder.serverProcesses;
        this.maxConcurrentGameSessionActivations = builder.maxConcurrentGameSessionActivations;
        this.gameSessionActivationTimeoutSeconds = builder.gameSessionActivationTimeoutSeconds;
    }

    public List<ServerProcess> serverProcesses() {
        return this.serverProcesses;
    }

    public Integer maxConcurrentGameSessionActivations() {
        return this.maxConcurrentGameSessionActivations;
    }

    public Integer gameSessionActivationTimeoutSeconds() {
        return this.gameSessionActivationTimeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProcesses());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentGameSessionActivations());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionActivationTimeoutSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeConfiguration)) {
            return false;
        }
        RuntimeConfiguration other = (RuntimeConfiguration)obj;
        return Objects.equals(this.serverProcesses(), other.serverProcesses()) && Objects.equals(this.maxConcurrentGameSessionActivations(), other.maxConcurrentGameSessionActivations()) && Objects.equals(this.gameSessionActivationTimeoutSeconds(), other.gameSessionActivationTimeoutSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serverProcesses() != null) {
            sb.append("ServerProcesses: ").append(this.serverProcesses()).append(",");
        }
        if (this.maxConcurrentGameSessionActivations() != null) {
            sb.append("MaxConcurrentGameSessionActivations: ").append(this.maxConcurrentGameSessionActivations()).append(",");
        }
        if (this.gameSessionActivationTimeoutSeconds() != null) {
            sb.append("GameSessionActivationTimeoutSeconds: ").append(this.gameSessionActivationTimeoutSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerProcesses": {
                return Optional.of(clazz.cast(this.serverProcesses()));
            }
            case "MaxConcurrentGameSessionActivations": {
                return Optional.of(clazz.cast(this.maxConcurrentGameSessionActivations()));
            }
            case "GameSessionActivationTimeoutSeconds": {
                return Optional.of(clazz.cast(this.gameSessionActivationTimeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuntimeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ServerProcess> serverProcesses;
        private Integer maxConcurrentGameSessionActivations;
        private Integer gameSessionActivationTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeConfiguration model) {
            this.serverProcesses(model.serverProcesses);
            this.maxConcurrentGameSessionActivations(model.maxConcurrentGameSessionActivations);
            this.gameSessionActivationTimeoutSeconds(model.gameSessionActivationTimeoutSeconds);
        }

        public final Collection<ServerProcess.Builder> getServerProcesses() {
            return this.serverProcesses != null ? (Collection)this.serverProcesses.stream().map(ServerProcess::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverProcesses(Collection<ServerProcess> serverProcesses) {
            this.serverProcesses = ServerProcessListCopier.copy(serverProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverProcesses(ServerProcess ... serverProcesses) {
            this.serverProcesses(Arrays.asList(serverProcesses));
            return this;
        }

        public final void setServerProcesses(Collection<ServerProcess.BuilderImpl> serverProcesses) {
            this.serverProcesses = ServerProcessListCopier.copyFromBuilder(serverProcesses);
        }

        public final Integer getMaxConcurrentGameSessionActivations() {
            return this.maxConcurrentGameSessionActivations;
        }

        @Override
        public final Builder maxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
            return this;
        }

        public final void setMaxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
            this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
        }

        public final Integer getGameSessionActivationTimeoutSeconds() {
            return this.gameSessionActivationTimeoutSeconds;
        }

        @Override
        public final Builder gameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
            return this;
        }

        public final void setGameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
            this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
        }

        public RuntimeConfiguration build() {
            return new RuntimeConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RuntimeConfiguration> {
        public Builder serverProcesses(Collection<ServerProcess> var1);

        public Builder serverProcesses(ServerProcess ... var1);

        public Builder maxConcurrentGameSessionActivations(Integer var1);

        public Builder gameSessionActivationTimeoutSeconds(Integer var1);
    }
}

