/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.PlayerLatencyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlayerLatency
implements StructuredPojo,
ToCopyableBuilder<Builder, PlayerLatency> {
    private final String playerId;
    private final String regionIdentifier;
    private final Float latencyInMilliseconds;

    private PlayerLatency(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.regionIdentifier = builder.regionIdentifier;
        this.latencyInMilliseconds = builder.latencyInMilliseconds;
    }

    public String playerId() {
        return this.playerId;
    }

    public String regionIdentifier() {
        return this.regionIdentifier;
    }

    public Float latencyInMilliseconds() {
        return this.latencyInMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyInMilliseconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatency)) {
            return false;
        }
        PlayerLatency other = (PlayerLatency)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.regionIdentifier(), other.regionIdentifier()) && Objects.equals(this.latencyInMilliseconds(), other.latencyInMilliseconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.regionIdentifier() != null) {
            sb.append("RegionIdentifier: ").append(this.regionIdentifier()).append(",");
        }
        if (this.latencyInMilliseconds() != null) {
            sb.append("LatencyInMilliseconds: ").append(this.latencyInMilliseconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.of(clazz.cast(this.playerId()));
            }
            case "RegionIdentifier": {
                return Optional.of(clazz.cast(this.regionIdentifier()));
            }
            case "LatencyInMilliseconds": {
                return Optional.of(clazz.cast(this.latencyInMilliseconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerLatencyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String regionIdentifier;
        private Float latencyInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatency model) {
            this.playerId(model.playerId);
            this.regionIdentifier(model.regionIdentifier);
            this.latencyInMilliseconds(model.latencyInMilliseconds);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getRegionIdentifier() {
            return this.regionIdentifier;
        }

        @Override
        public final Builder regionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
            return this;
        }

        public final void setRegionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
        }

        public final Float getLatencyInMilliseconds() {
            return this.latencyInMilliseconds;
        }

        @Override
        public final Builder latencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
            return this;
        }

        public final void setLatencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
        }

        public PlayerLatency build() {
            return new PlayerLatency(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlayerLatency> {
        public Builder playerId(String var1);

        public Builder regionIdentifier(String var1);

        public Builder latencyInMilliseconds(Float var1);
    }
}

