/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.AttributeValue;
import software.amazon.awssdk.services.gamelift.model.LatencyMapCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerAttributeMapCopier;
import software.amazon.awssdk.services.gamelift.transform.PlayerMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Player
implements StructuredPojo,
ToCopyableBuilder<Builder, Player> {
    private final String playerId;
    private final Map<String, AttributeValue> playerAttributes;
    private final String team;
    private final Map<String, Integer> latencyInMs;

    private Player(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerAttributes = builder.playerAttributes;
        this.team = builder.team;
        this.latencyInMs = builder.latencyInMs;
    }

    public String playerId() {
        return this.playerId;
    }

    public Map<String, AttributeValue> playerAttributes() {
        return this.playerAttributes;
    }

    public String team() {
        return this.team;
    }

    public Map<String, Integer> latencyInMs() {
        return this.latencyInMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.team());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyInMs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Player)) {
            return false;
        }
        Player other = (Player)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerAttributes(), other.playerAttributes()) && Objects.equals(this.team(), other.team()) && Objects.equals(this.latencyInMs(), other.latencyInMs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.playerAttributes() != null) {
            sb.append("PlayerAttributes: ").append(this.playerAttributes()).append(",");
        }
        if (this.team() != null) {
            sb.append("Team: ").append(this.team()).append(",");
        }
        if (this.latencyInMs() != null) {
            sb.append("LatencyInMs: ").append(this.latencyInMs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.of(clazz.cast(this.playerId()));
            }
            case "PlayerAttributes": {
                return Optional.of(clazz.cast(this.playerAttributes()));
            }
            case "Team": {
                return Optional.of(clazz.cast(this.team()));
            }
            case "LatencyInMs": {
                return Optional.of(clazz.cast(this.latencyInMs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private Map<String, AttributeValue> playerAttributes;
        private String team;
        private Map<String, Integer> latencyInMs;

        private BuilderImpl() {
        }

        private BuilderImpl(Player model) {
            this.playerId(model.playerId);
            this.playerAttributes(model.playerAttributes);
            this.team(model.team);
            this.latencyInMs(model.latencyInMs);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final Map<String, AttributeValue.Builder> getPlayerAttributes() {
            return this.playerAttributes != null ? CollectionUtils.mapValues(this.playerAttributes, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder playerAttributes(Map<String, AttributeValue> playerAttributes) {
            this.playerAttributes = PlayerAttributeMapCopier.copy(playerAttributes);
            return this;
        }

        public final void setPlayerAttributes(Map<String, AttributeValue.BuilderImpl> playerAttributes) {
            this.playerAttributes = PlayerAttributeMapCopier.copyFromBuilder(playerAttributes);
        }

        public final String getTeam() {
            return this.team;
        }

        @Override
        public final Builder team(String team) {
            this.team = team;
            return this;
        }

        public final void setTeam(String team) {
            this.team = team;
        }

        public final Map<String, Integer> getLatencyInMs() {
            return this.latencyInMs;
        }

        @Override
        public final Builder latencyInMs(Map<String, Integer> latencyInMs) {
            this.latencyInMs = LatencyMapCopier.copy(latencyInMs);
            return this;
        }

        public final void setLatencyInMs(Map<String, Integer> latencyInMs) {
            this.latencyInMs = LatencyMapCopier.copy(latencyInMs);
        }

        public Player build() {
            return new Player(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Player> {
        public Builder playerId(String var1);

        public Builder playerAttributes(Map<String, AttributeValue> var1);

        public Builder team(String var1);

        public Builder latencyInMs(Map<String, Integer> var1);
    }
}

