/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePlayerSessionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePlayerSessionsRequest> {
    private final String gameSessionId;
    private final String playerId;
    private final String playerSessionId;
    private final String playerSessionStatusFilter;
    private final Integer limit;
    private final String nextToken;

    private DescribePlayerSessionsRequest(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
        this.playerSessionStatusFilter = builder.playerSessionStatusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerSessionId() {
        return this.playerSessionId;
    }

    public String playerSessionStatusFilter() {
        return this.playerSessionStatusFilter;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlayerSessionsRequest)) {
            return false;
        }
        DescribePlayerSessionsRequest other = (DescribePlayerSessionsRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerSessionId(), other.playerSessionId()) && Objects.equals(this.playerSessionStatusFilter(), other.playerSessionStatusFilter()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.playerSessionId() != null) {
            sb.append("PlayerSessionId: ").append(this.playerSessionId()).append(",");
        }
        if (this.playerSessionStatusFilter() != null) {
            sb.append("PlayerSessionStatusFilter: ").append(this.playerSessionStatusFilter()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "PlayerId": {
                return Optional.of(clazz.cast(this.playerId()));
            }
            case "PlayerSessionId": {
                return Optional.of(clazz.cast(this.playerSessionId()));
            }
            case "PlayerSessionStatusFilter": {
                return Optional.of(clazz.cast(this.playerSessionStatusFilter()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerSessionId;
        private String playerSessionStatusFilter;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlayerSessionsRequest model) {
            this.gameSessionId(model.gameSessionId);
            this.playerId(model.playerId);
            this.playerSessionId(model.playerSessionId);
            this.playerSessionStatusFilter(model.playerSessionStatusFilter);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerSessionId() {
            return this.playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        public final String getPlayerSessionStatusFilter() {
            return this.playerSessionStatusFilter;
        }

        @Override
        public final Builder playerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
            return this;
        }

        public final void setPlayerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribePlayerSessionsRequest build() {
            return new DescribePlayerSessionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerSessionId(String var1);

        public Builder playerSessionStatusFilter(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

