/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.FleetIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeFleetAttributesRequest> {
    private final List<String> fleetIds;
    private final Integer limit;
    private final String nextToken;

    private DescribeFleetAttributesRequest(BuilderImpl builder) {
        this.fleetIds = builder.fleetIds;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public List<String> fleetIds() {
        return this.fleetIds;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAttributesRequest)) {
            return false;
        }
        DescribeFleetAttributesRequest other = (DescribeFleetAttributesRequest)((Object)obj);
        return Objects.equals(this.fleetIds(), other.fleetIds()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetIds() != null) {
            sb.append("FleetIds: ").append(this.fleetIds()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetIds": {
                return Optional.of(clazz.cast(this.fleetIds()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> fleetIds;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAttributesRequest model) {
            this.fleetIds(model.fleetIds);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFleetIds() {
            return this.fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFleetAttributesRequest build() {
            return new DescribeFleetAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetAttributesRequest> {
        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

