/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteVpcPeeringAuthorizationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteVpcPeeringAuthorizationRequest> {
    private final String gameLiftAwsAccountId;
    private final String peerVpcId;

    private DeleteVpcPeeringAuthorizationRequest(BuilderImpl builder) {
        this.gameLiftAwsAccountId = builder.gameLiftAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
    }

    public String gameLiftAwsAccountId() {
        return this.gameLiftAwsAccountId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameLiftAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcPeeringAuthorizationRequest)) {
            return false;
        }
        DeleteVpcPeeringAuthorizationRequest other = (DeleteVpcPeeringAuthorizationRequest)((Object)obj);
        return Objects.equals(this.gameLiftAwsAccountId(), other.gameLiftAwsAccountId()) && Objects.equals(this.peerVpcId(), other.peerVpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.gameLiftAwsAccountId() != null) {
            sb.append("GameLiftAwsAccountId: ").append(this.gameLiftAwsAccountId()).append(",");
        }
        if (this.peerVpcId() != null) {
            sb.append("PeerVpcId: ").append(this.peerVpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameLiftAwsAccountId": {
                return Optional.of(clazz.cast(this.gameLiftAwsAccountId()));
            }
            case "PeerVpcId": {
                return Optional.of(clazz.cast(this.peerVpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String gameLiftAwsAccountId;
        private String peerVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcPeeringAuthorizationRequest model) {
            this.gameLiftAwsAccountId(model.gameLiftAwsAccountId);
            this.peerVpcId(model.peerVpcId);
        }

        public final String getGameLiftAwsAccountId() {
            return this.gameLiftAwsAccountId;
        }

        @Override
        public final Builder gameLiftAwsAccountId(String gameLiftAwsAccountId) {
            this.gameLiftAwsAccountId = gameLiftAwsAccountId;
            return this;
        }

        public final void setGameLiftAwsAccountId(String gameLiftAwsAccountId) {
            this.gameLiftAwsAccountId = gameLiftAwsAccountId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public DeleteVpcPeeringAuthorizationRequest build() {
            return new DeleteVpcPeeringAuthorizationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteVpcPeeringAuthorizationRequest> {
        public Builder gameLiftAwsAccountId(String var1);

        public Builder peerVpcId(String var1);
    }
}

