/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.transform.GamePropertyUnmarshaller;

public class GameSessionUnmarshaller
implements Unmarshaller<GameSession, JsonUnmarshallerContext> {
    private static final GameSessionUnmarshaller INSTANCE = new GameSessionUnmarshaller();

    public GameSession unmarshall(JsonUnmarshallerContext context) throws Exception {
        GameSession.Builder gameSessionBuilder = GameSession.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("GameSessionId", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.gameSessionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FleetId", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.fleetId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("TerminationTime", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.terminationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("CurrentPlayerSessionCount", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.currentPlayerSessionCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaximumPlayerSessionCount", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.maximumPlayerSessionCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("GameProperties", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.gameProperties(new ListUnmarshaller((Unmarshaller)GamePropertyUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("IpAddress", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.ipAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Port", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.port((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PlayerSessionCreationPolicy", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.playerSessionCreationPolicy((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatorId", targetDepth)) {
                    context.nextToken();
                    gameSessionBuilder.creatorId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GameSession)gameSessionBuilder.build();
    }

    public static GameSessionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

