/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFleetPortSettingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
    private final String fleetId;
    private final List<IpPermission> inboundPermissionAuthorizations;
    private final List<IpPermission> inboundPermissionRevocations;

    private UpdateFleetPortSettingsRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.inboundPermissionAuthorizations = builder.inboundPermissionAuthorizations;
        this.inboundPermissionRevocations = builder.inboundPermissionRevocations;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public List<IpPermission> inboundPermissionAuthorizations() {
        return this.inboundPermissionAuthorizations;
    }

    public List<IpPermission> inboundPermissionRevocations() {
        return this.inboundPermissionRevocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.inboundPermissionAuthorizations() == null ? 0 : this.inboundPermissionAuthorizations().hashCode());
        hashCode = 31 * hashCode + (this.inboundPermissionRevocations() == null ? 0 : this.inboundPermissionRevocations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetPortSettingsRequest)) {
            return false;
        }
        UpdateFleetPortSettingsRequest other = (UpdateFleetPortSettingsRequest)((Object)obj);
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.inboundPermissionAuthorizations() == null ^ this.inboundPermissionAuthorizations() == null) {
            return false;
        }
        if (other.inboundPermissionAuthorizations() != null && !other.inboundPermissionAuthorizations().equals(this.inboundPermissionAuthorizations())) {
            return false;
        }
        if (other.inboundPermissionRevocations() == null ^ this.inboundPermissionRevocations() == null) {
            return false;
        }
        return other.inboundPermissionRevocations() == null || other.inboundPermissionRevocations().equals(this.inboundPermissionRevocations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.inboundPermissionAuthorizations() != null) {
            sb.append("InboundPermissionAuthorizations: ").append(this.inboundPermissionAuthorizations()).append(",");
        }
        if (this.inboundPermissionRevocations() != null) {
            sb.append("InboundPermissionRevocations: ").append(this.inboundPermissionRevocations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "InboundPermissionAuthorizations": {
                return Optional.of(clazz.cast(this.inboundPermissionAuthorizations()));
            }
            case "InboundPermissionRevocations": {
                return Optional.of(clazz.cast(this.inboundPermissionRevocations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private List<IpPermission> inboundPermissionAuthorizations;
        private List<IpPermission> inboundPermissionRevocations;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetPortSettingsRequest model) {
            this.fleetId(model.fleetId);
            this.inboundPermissionAuthorizations(model.inboundPermissionAuthorizations);
            this.inboundPermissionRevocations(model.inboundPermissionRevocations);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<IpPermission.Builder> getInboundPermissionAuthorizations() {
            return this.inboundPermissionAuthorizations != null ? (Collection)this.inboundPermissionAuthorizations.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionAuthorizations(Collection<IpPermission> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copy(inboundPermissionAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionAuthorizations(IpPermission ... inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations(Arrays.asList(inboundPermissionAuthorizations));
            return this;
        }

        public final void setInboundPermissionAuthorizations(Collection<IpPermission.BuilderImpl> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionAuthorizations);
        }

        public final Collection<IpPermission.Builder> getInboundPermissionRevocations() {
            return this.inboundPermissionRevocations != null ? (Collection)this.inboundPermissionRevocations.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionRevocations(Collection<IpPermission> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copy(inboundPermissionRevocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionRevocations(IpPermission ... inboundPermissionRevocations) {
            this.inboundPermissionRevocations(Arrays.asList(inboundPermissionRevocations));
            return this;
        }

        public final void setInboundPermissionRevocations(Collection<IpPermission.BuilderImpl> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionRevocations);
        }

        public UpdateFleetPortSettingsRequest build() {
            return new UpdateFleetPortSettingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
        public Builder fleetId(String var1);

        public Builder inboundPermissionAuthorizations(Collection<IpPermission> var1);

        public Builder inboundPermissionAuthorizations(IpPermission ... var1);

        public Builder inboundPermissionRevocations(Collection<IpPermission> var1);

        public Builder inboundPermissionRevocations(IpPermission ... var1);
    }
}

