/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession;
import software.amazon.awssdk.services.gamelift.model.DesiredPlayerSessionListCopier;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatency;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartGameSessionPlacementRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StartGameSessionPlacementRequest> {
    private final String placementId;
    private final String gameSessionQueueName;
    private final List<GameProperty> gameProperties;
    private final Integer maximumPlayerSessionCount;
    private final String gameSessionName;
    private final List<PlayerLatency> playerLatencies;
    private final List<DesiredPlayerSession> desiredPlayerSessions;

    private StartGameSessionPlacementRequest(BuilderImpl builder) {
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.playerLatencies = builder.playerLatencies;
        this.desiredPlayerSessions = builder.desiredPlayerSessions;
    }

    public String placementId() {
        return this.placementId;
    }

    public String gameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String gameSessionName() {
        return this.gameSessionName;
    }

    public List<PlayerLatency> playerLatencies() {
        return this.playerLatencies;
    }

    public List<DesiredPlayerSession> desiredPlayerSessions() {
        return this.desiredPlayerSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.placementId() == null ? 0 : this.placementId().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionQueueName() == null ? 0 : this.gameSessionQueueName().hashCode());
        hashCode = 31 * hashCode + (this.gameProperties() == null ? 0 : this.gameProperties().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionName() == null ? 0 : this.gameSessionName().hashCode());
        hashCode = 31 * hashCode + (this.playerLatencies() == null ? 0 : this.playerLatencies().hashCode());
        hashCode = 31 * hashCode + (this.desiredPlayerSessions() == null ? 0 : this.desiredPlayerSessions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGameSessionPlacementRequest)) {
            return false;
        }
        StartGameSessionPlacementRequest other = (StartGameSessionPlacementRequest)((Object)obj);
        if (other.placementId() == null ^ this.placementId() == null) {
            return false;
        }
        if (other.placementId() != null && !other.placementId().equals(this.placementId())) {
            return false;
        }
        if (other.gameSessionQueueName() == null ^ this.gameSessionQueueName() == null) {
            return false;
        }
        if (other.gameSessionQueueName() != null && !other.gameSessionQueueName().equals(this.gameSessionQueueName())) {
            return false;
        }
        if (other.gameProperties() == null ^ this.gameProperties() == null) {
            return false;
        }
        if (other.gameProperties() != null && !other.gameProperties().equals(this.gameProperties())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.maximumPlayerSessionCount() != null && !other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount())) {
            return false;
        }
        if (other.gameSessionName() == null ^ this.gameSessionName() == null) {
            return false;
        }
        if (other.gameSessionName() != null && !other.gameSessionName().equals(this.gameSessionName())) {
            return false;
        }
        if (other.playerLatencies() == null ^ this.playerLatencies() == null) {
            return false;
        }
        if (other.playerLatencies() != null && !other.playerLatencies().equals(this.playerLatencies())) {
            return false;
        }
        if (other.desiredPlayerSessions() == null ^ this.desiredPlayerSessions() == null) {
            return false;
        }
        return other.desiredPlayerSessions() == null || other.desiredPlayerSessions().equals(this.desiredPlayerSessions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.placementId() != null) {
            sb.append("PlacementId: ").append(this.placementId()).append(",");
        }
        if (this.gameSessionQueueName() != null) {
            sb.append("GameSessionQueueName: ").append(this.gameSessionQueueName()).append(",");
        }
        if (this.gameProperties() != null) {
            sb.append("GameProperties: ").append(this.gameProperties()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        if (this.gameSessionName() != null) {
            sb.append("GameSessionName: ").append(this.gameSessionName()).append(",");
        }
        if (this.playerLatencies() != null) {
            sb.append("PlayerLatencies: ").append(this.playerLatencies()).append(",");
        }
        if (this.desiredPlayerSessions() != null) {
            sb.append("DesiredPlayerSessions: ").append(this.desiredPlayerSessions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementId": {
                return Optional.of(clazz.cast(this.placementId()));
            }
            case "GameSessionQueueName": {
                return Optional.of(clazz.cast(this.gameSessionQueueName()));
            }
            case "GameProperties": {
                return Optional.of(clazz.cast(this.gameProperties()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.of(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "GameSessionName": {
                return Optional.of(clazz.cast(this.gameSessionName()));
            }
            case "PlayerLatencies": {
                return Optional.of(clazz.cast(this.playerLatencies()));
            }
            case "DesiredPlayerSessions": {
                return Optional.of(clazz.cast(this.desiredPlayerSessions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String placementId;
        private String gameSessionQueueName;
        private List<GameProperty> gameProperties;
        private Integer maximumPlayerSessionCount;
        private String gameSessionName;
        private List<PlayerLatency> playerLatencies;
        private List<DesiredPlayerSession> desiredPlayerSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(StartGameSessionPlacementRequest model) {
            this.placementId(model.placementId);
            this.gameSessionQueueName(model.gameSessionQueueName);
            this.gameProperties(model.gameProperties);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.gameSessionName(model.gameSessionName);
            this.playerLatencies(model.playerLatencies);
            this.desiredPlayerSessions(model.desiredPlayerSessions);
        }

        public final String getPlacementId() {
            return this.placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        public final String getGameSessionQueueName() {
            return this.gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getGameSessionName() {
            return this.gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        public final Collection<PlayerLatency.Builder> getPlayerLatencies() {
            return this.playerLatencies != null ? (Collection)this.playerLatencies.stream().map(PlayerLatency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency ... playerLatencies) {
            this.playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency.BuilderImpl> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copyFromBuilder(playerLatencies);
        }

        public final Collection<DesiredPlayerSession.Builder> getDesiredPlayerSessions() {
            return this.desiredPlayerSessions != null ? (Collection)this.desiredPlayerSessions.stream().map(DesiredPlayerSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder desiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copy(desiredPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredPlayerSessions(DesiredPlayerSession ... desiredPlayerSessions) {
            this.desiredPlayerSessions(Arrays.asList(desiredPlayerSessions));
            return this;
        }

        public final void setDesiredPlayerSessions(Collection<DesiredPlayerSession.BuilderImpl> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copyFromBuilder(desiredPlayerSessions);
        }

        public StartGameSessionPlacementRequest build() {
            return new StartGameSessionPlacementRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartGameSessionPlacementRequest> {
        public Builder placementId(String var1);

        public Builder gameSessionQueueName(String var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder gameSessionName(String var1);

        public Builder playerLatencies(Collection<PlayerLatency> var1);

        public Builder playerLatencies(PlayerLatency ... var1);

        public Builder desiredPlayerSessions(Collection<DesiredPlayerSession> var1);

        public Builder desiredPlayerSessions(DesiredPlayerSession ... var1);
    }
}

