/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.ServerProcessMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServerProcess
implements StructuredPojo,
ToCopyableBuilder<Builder, ServerProcess> {
    private final String launchPath;
    private final String parameters;
    private final Integer concurrentExecutions;

    private ServerProcess(BuilderImpl builder) {
        this.launchPath = builder.launchPath;
        this.parameters = builder.parameters;
        this.concurrentExecutions = builder.concurrentExecutions;
    }

    public String launchPath() {
        return this.launchPath;
    }

    public String parameters() {
        return this.parameters;
    }

    public Integer concurrentExecutions() {
        return this.concurrentExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.launchPath() == null ? 0 : this.launchPath().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.concurrentExecutions() == null ? 0 : this.concurrentExecutions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerProcess)) {
            return false;
        }
        ServerProcess other = (ServerProcess)obj;
        if (other.launchPath() == null ^ this.launchPath() == null) {
            return false;
        }
        if (other.launchPath() != null && !other.launchPath().equals(this.launchPath())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.concurrentExecutions() == null ^ this.concurrentExecutions() == null) {
            return false;
        }
        return other.concurrentExecutions() == null || other.concurrentExecutions().equals(this.concurrentExecutions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.launchPath() != null) {
            sb.append("LaunchPath: ").append(this.launchPath()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.concurrentExecutions() != null) {
            sb.append("ConcurrentExecutions: ").append(this.concurrentExecutions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchPath": {
                return Optional.of(clazz.cast(this.launchPath()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "ConcurrentExecutions": {
                return Optional.of(clazz.cast(this.concurrentExecutions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServerProcessMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchPath;
        private String parameters;
        private Integer concurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerProcess model) {
            this.launchPath(model.launchPath);
            this.parameters(model.parameters);
            this.concurrentExecutions(model.concurrentExecutions);
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        public final String getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final Integer getConcurrentExecutions() {
            return this.concurrentExecutions;
        }

        @Override
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        public ServerProcess build() {
            return new ServerProcess(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServerProcess> {
        public Builder launchPath(String var1);

        public Builder parameters(String var1);

        public Builder concurrentExecutions(Integer var1);
    }
}

