/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.Build;
import software.amazon.awssdk.services.gamelift.model.BuildListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBuildsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBuildsResponse> {
    private final List<Build> builds;
    private final String nextToken;

    private ListBuildsResponse(BuilderImpl builder) {
        this.builds = builder.builds;
        this.nextToken = builder.nextToken;
    }

    public List<Build> builds() {
        return this.builds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.builds() == null ? 0 : this.builds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResponse)) {
            return false;
        }
        ListBuildsResponse other = (ListBuildsResponse)((Object)obj);
        if (other.builds() == null ^ this.builds() == null) {
            return false;
        }
        if (other.builds() != null && !other.builds().equals(this.builds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.builds() != null) {
            sb.append("Builds: ").append(this.builds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Builds": {
                return Optional.of(clazz.cast(this.builds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Build> builds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsResponse model) {
            this.builds(model.builds);
            this.nextToken(model.nextToken);
        }

        public final Collection<Build.Builder> getBuilds() {
            return this.builds != null ? (Collection)this.builds.stream().map(Build::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildListCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build ... builds) {
            this.builds(Arrays.asList(builds));
            return this;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildListCopier.copyFromBuilder(builds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListBuildsResponse build() {
            return new ListBuildsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBuildsResponse> {
        public Builder builds(Collection<Build> var1);

        public Builder builds(Build ... var1);

        public Builder nextToken(String var1);
    }
}

