/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.IpProtocol;
import software.amazon.awssdk.services.gamelift.transform.IpPermissionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IpPermission
implements StructuredPojo,
ToCopyableBuilder<Builder, IpPermission> {
    private final Integer fromPort;
    private final Integer toPort;
    private final String ipRange;
    private final String protocol;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.ipRange = builder.ipRange;
        this.protocol = builder.protocol;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public String ipRange() {
        return this.ipRange;
    }

    public IpProtocol protocol() {
        return IpProtocol.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fromPort() == null ? 0 : this.fromPort().hashCode());
        hashCode = 31 * hashCode + (this.toPort() == null ? 0 : this.toPort().hashCode());
        hashCode = 31 * hashCode + (this.ipRange() == null ? 0 : this.ipRange().hashCode());
        hashCode = 31 * hashCode + (this.protocolString() == null ? 0 : this.protocolString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.ipRange() == null ^ this.ipRange() == null) {
            return false;
        }
        if (other.ipRange() != null && !other.ipRange().equals(this.ipRange())) {
            return false;
        }
        if (other.protocolString() == null ^ this.protocolString() == null) {
            return false;
        }
        return other.protocolString() == null || other.protocolString().equals(this.protocolString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (this.ipRange() != null) {
            sb.append("IpRange: ").append(this.ipRange()).append(",");
        }
        if (this.protocolString() != null) {
            sb.append("Protocol: ").append(this.protocolString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromPort": {
                return Optional.of(clazz.cast(this.fromPort()));
            }
            case "ToPort": {
                return Optional.of(clazz.cast(this.toPort()));
            }
            case "IpRange": {
                return Optional.of(clazz.cast(this.ipRange()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IpPermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String ipRange;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.ipRange(model.ipRange);
            this.protocol(model.protocol);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getIpRange() {
            return this.ipRange;
        }

        @Override
        public final Builder ipRange(String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        public final void setIpRange(String ipRange) {
            this.ipRange = ipRange;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(IpProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public IpPermission build() {
            return new IpPermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IpPermission> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder ipRange(String var1);

        public Builder protocol(String var1);

        public Builder protocol(IpProtocol var1);
    }
}

