/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.ScalingPolicy;
import software.amazon.awssdk.services.gamelift.model.ScalingPolicyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalingPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
    private final List<ScalingPolicy> scalingPolicies;
    private final String nextToken;

    private DescribeScalingPoliciesResponse(BuilderImpl builder) {
        this.scalingPolicies = builder.scalingPolicies;
        this.nextToken = builder.nextToken;
    }

    public List<ScalingPolicy> scalingPolicies() {
        return this.scalingPolicies;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.scalingPolicies() == null ? 0 : this.scalingPolicies().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPoliciesResponse)) {
            return false;
        }
        DescribeScalingPoliciesResponse other = (DescribeScalingPoliciesResponse)((Object)obj);
        if (other.scalingPolicies() == null ^ this.scalingPolicies() == null) {
            return false;
        }
        if (other.scalingPolicies() != null && !other.scalingPolicies().equals(this.scalingPolicies())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.scalingPolicies() != null) {
            sb.append("ScalingPolicies: ").append(this.scalingPolicies()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPolicies": {
                return Optional.of(clazz.cast(this.scalingPolicies()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ScalingPolicy> scalingPolicies;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPoliciesResponse model) {
            this.scalingPolicies(model.scalingPolicies);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScalingPolicy.Builder> getScalingPolicies() {
            return this.scalingPolicies != null ? (Collection)this.scalingPolicies.stream().map(ScalingPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPolicyListCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPolicyListCopier.copyFromBuilder(scalingPolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScalingPoliciesResponse build() {
            return new DescribeScalingPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
        public Builder scalingPolicies(Collection<ScalingPolicy> var1);

        public Builder scalingPolicies(ScalingPolicy ... var1);

        public Builder nextToken(String var1);
    }
}

