/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionDetailsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeGameSessionDetailsRequest> {
    private final String fleetId;
    private final String gameSessionId;
    private final String aliasId;
    private final String statusFilter;
    private final Integer limit;
    private final String nextToken;

    private DescribeGameSessionDetailsRequest(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.gameSessionId = builder.gameSessionId;
        this.aliasId = builder.aliasId;
        this.statusFilter = builder.statusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public String statusFilter() {
        return this.statusFilter;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.aliasId() == null ? 0 : this.aliasId().hashCode());
        hashCode = 31 * hashCode + (this.statusFilter() == null ? 0 : this.statusFilter().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionDetailsRequest)) {
            return false;
        }
        DescribeGameSessionDetailsRequest other = (DescribeGameSessionDetailsRequest)((Object)obj);
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.aliasId() == null ^ this.aliasId() == null) {
            return false;
        }
        if (other.aliasId() != null && !other.aliasId().equals(this.aliasId())) {
            return false;
        }
        if (other.statusFilter() == null ^ this.statusFilter() == null) {
            return false;
        }
        if (other.statusFilter() != null && !other.statusFilter().equals(this.statusFilter())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.aliasId() != null) {
            sb.append("AliasId: ").append(this.aliasId()).append(",");
        }
        if (this.statusFilter() != null) {
            sb.append("StatusFilter: ").append(this.statusFilter()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "AliasId": {
                return Optional.of(clazz.cast(this.aliasId()));
            }
            case "StatusFilter": {
                return Optional.of(clazz.cast(this.statusFilter()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String gameSessionId;
        private String aliasId;
        private String statusFilter;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionDetailsRequest model) {
            this.fleetId(model.fleetId);
            this.gameSessionId(model.gameSessionId);
            this.aliasId(model.aliasId);
            this.statusFilter(model.statusFilter);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getStatusFilter() {
            return this.statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeGameSessionDetailsRequest build() {
            return new DescribeGameSessionDetailsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeGameSessionDetailsRequest> {
        public Builder fleetId(String var1);

        public Builder gameSessionId(String var1);

        public Builder aliasId(String var1);

        public Builder statusFilter(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

