/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetCapacityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFleetCapacityResponse> {
    private final List<FleetCapacity> fleetCapacity;
    private final String nextToken;

    private DescribeFleetCapacityResponse(BuilderImpl builder) {
        this.fleetCapacity = builder.fleetCapacity;
        this.nextToken = builder.nextToken;
    }

    public List<FleetCapacity> fleetCapacity() {
        return this.fleetCapacity;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetCapacity() == null ? 0 : this.fleetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetCapacityResponse)) {
            return false;
        }
        DescribeFleetCapacityResponse other = (DescribeFleetCapacityResponse)((Object)obj);
        if (other.fleetCapacity() == null ^ this.fleetCapacity() == null) {
            return false;
        }
        if (other.fleetCapacity() != null && !other.fleetCapacity().equals(this.fleetCapacity())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fleetCapacity() != null) {
            sb.append("FleetCapacity: ").append(this.fleetCapacity()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetCapacity": {
                return Optional.of(clazz.cast(this.fleetCapacity()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<FleetCapacity> fleetCapacity;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetCapacityResponse model) {
            this.fleetCapacity(model.fleetCapacity);
            this.nextToken(model.nextToken);
        }

        public final Collection<FleetCapacity.Builder> getFleetCapacity() {
            return this.fleetCapacity != null ? (Collection)this.fleetCapacity.stream().map(FleetCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetCapacity(Collection<FleetCapacity> fleetCapacity) {
            this.fleetCapacity = FleetCapacityListCopier.copy(fleetCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacity(FleetCapacity ... fleetCapacity) {
            this.fleetCapacity(Arrays.asList(fleetCapacity));
            return this;
        }

        public final void setFleetCapacity(Collection<FleetCapacity.BuilderImpl> fleetCapacity) {
            this.fleetCapacity = FleetCapacityListCopier.copyFromBuilder(fleetCapacity);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFleetCapacityResponse build() {
            return new DescribeFleetCapacityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetCapacityResponse> {
        public Builder fleetCapacity(Collection<FleetCapacity> var1);

        public Builder fleetCapacity(FleetCapacity ... var1);

        public Builder nextToken(String var1);
    }
}

