/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.CredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Credentials
implements StructuredPojo,
ToCopyableBuilder<Builder, Credentials> {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;

    private Credentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accessKeyId() == null ? 0 : this.accessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.secretAccessKey() == null ? 0 : this.secretAccessKey().hashCode());
        hashCode = 31 * hashCode + (this.sessionToken() == null ? 0 : this.sessionToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)obj;
        if (other.accessKeyId() == null ^ this.accessKeyId() == null) {
            return false;
        }
        if (other.accessKeyId() != null && !other.accessKeyId().equals(this.accessKeyId())) {
            return false;
        }
        if (other.secretAccessKey() == null ^ this.secretAccessKey() == null) {
            return false;
        }
        if (other.secretAccessKey() != null && !other.secretAccessKey().equals(this.secretAccessKey())) {
            return false;
        }
        if (other.sessionToken() == null ^ this.sessionToken() == null) {
            return false;
        }
        return other.sessionToken() == null || other.sessionToken().equals(this.sessionToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.accessKeyId()).append(",");
        }
        if (this.secretAccessKey() != null) {
            sb.append("SecretAccessKey: ").append(this.secretAccessKey()).append(",");
        }
        if (this.sessionToken() != null) {
            sb.append("SessionToken: ").append(this.sessionToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyId": {
                return Optional.of(clazz.cast(this.accessKeyId()));
            }
            case "SecretAccessKey": {
                return Optional.of(clazz.cast(this.secretAccessKey()));
            }
            case "SessionToken": {
                return Optional.of(clazz.cast(this.sessionToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            this.accessKeyId(model.accessKeyId);
            this.secretAccessKey(model.secretAccessKey);
            this.sessionToken(model.sessionToken);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public Credentials build() {
            return new Credentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Credentials> {
        public Builder accessKeyId(String var1);

        public Builder secretAccessKey(String var1);

        public Builder sessionToken(String var1);
    }
}

