/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.RoutingStrategy;
import software.amazon.awssdk.services.gamelift.transform.AliasMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Alias
implements StructuredPojo,
ToCopyableBuilder<Builder, Alias> {
    private final String aliasId;
    private final String name;
    private final String aliasArn;
    private final String description;
    private final RoutingStrategy routingStrategy;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;

    private Alias(BuilderImpl builder) {
        this.aliasId = builder.aliasId;
        this.name = builder.name;
        this.aliasArn = builder.aliasArn;
        this.description = builder.description;
        this.routingStrategy = builder.routingStrategy;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public String name() {
        return this.name;
    }

    public String aliasArn() {
        return this.aliasArn;
    }

    public String description() {
        return this.description;
    }

    public RoutingStrategy routingStrategy() {
        return this.routingStrategy;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aliasId() == null ? 0 : this.aliasId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.aliasArn() == null ? 0 : this.aliasArn().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.routingStrategy() == null ? 0 : this.routingStrategy().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTime() == null ? 0 : this.lastUpdatedTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alias)) {
            return false;
        }
        Alias other = (Alias)obj;
        if (other.aliasId() == null ^ this.aliasId() == null) {
            return false;
        }
        if (other.aliasId() != null && !other.aliasId().equals(this.aliasId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.aliasArn() == null ^ this.aliasArn() == null) {
            return false;
        }
        if (other.aliasArn() != null && !other.aliasArn().equals(this.aliasArn())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.routingStrategy() == null ^ this.routingStrategy() == null) {
            return false;
        }
        if (other.routingStrategy() != null && !other.routingStrategy().equals(this.routingStrategy())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        return other.lastUpdatedTime() == null || other.lastUpdatedTime().equals(this.lastUpdatedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.aliasId() != null) {
            sb.append("AliasId: ").append(this.aliasId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.aliasArn() != null) {
            sb.append("AliasArn: ").append(this.aliasArn()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.routingStrategy() != null) {
            sb.append("RoutingStrategy: ").append(this.routingStrategy()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.lastUpdatedTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasId": {
                return Optional.of(clazz.cast(this.aliasId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "AliasArn": {
                return Optional.of(clazz.cast(this.aliasArn()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "RoutingStrategy": {
                return Optional.of(clazz.cast(this.routingStrategy()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.of(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AliasMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasId;
        private String name;
        private String aliasArn;
        private String description;
        private RoutingStrategy routingStrategy;
        private Instant creationTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Alias model) {
            this.aliasId(model.aliasId);
            this.name(model.name);
            this.aliasArn(model.aliasArn);
            this.description(model.description);
            this.routingStrategy(model.routingStrategy);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final RoutingStrategy.Builder getRoutingStrategy() {
            return this.routingStrategy != null ? this.routingStrategy.toBuilder() : null;
        }

        @Override
        public final Builder routingStrategy(RoutingStrategy routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        public final void setRoutingStrategy(RoutingStrategy.BuilderImpl routingStrategy) {
            this.routingStrategy = routingStrategy != null ? routingStrategy.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public Alias build() {
            return new Alias(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Alias> {
        public Builder aliasId(String var1);

        public Builder name(String var1);

        public Builder aliasArn(String var1);

        public Builder description(String var1);

        public Builder routingStrategy(RoutingStrategy var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

