/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.InstanceCredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceCredentials
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceCredentials> {
    private final String userName;
    private final String secret;

    private InstanceCredentials(BuilderImpl builder) {
        this.userName = builder.userName;
        this.secret = builder.secret;
    }

    public String userName() {
        return this.userName;
    }

    public String secret() {
        return this.secret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.secret() == null ? 0 : this.secret().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCredentials)) {
            return false;
        }
        InstanceCredentials other = (InstanceCredentials)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.secret() == null ^ this.secret() == null) {
            return false;
        }
        return other.secret() == null || other.secret().equals(this.secret());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.secret() != null) {
            sb.append("Secret: ").append(this.secret()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private String secret;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCredentials model) {
            this.setUserName(model.userName);
            this.setSecret(model.secret);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSecret() {
            return this.secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        public InstanceCredentials build() {
            return new InstanceCredentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCredentials> {
        public Builder userName(String var1);

        public Builder secret(String var1);
    }
}

