/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.InstanceCredentials;
import software.amazon.awssdk.services.gamelift.model.OperatingSystem;
import software.amazon.awssdk.services.gamelift.transform.InstanceAccessMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAccess
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAccess> {
    private final String fleetId;
    private final String instanceId;
    private final String ipAddress;
    private final String operatingSystem;
    private final InstanceCredentials credentials;

    private InstanceAccess(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.instanceId = builder.instanceId;
        this.ipAddress = builder.ipAddress;
        this.operatingSystem = builder.operatingSystem;
        this.credentials = builder.credentials;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String operatingSystem() {
        return this.operatingSystem;
    }

    public InstanceCredentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.operatingSystem() == null ? 0 : this.operatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.credentials() == null ? 0 : this.credentials().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccess)) {
            return false;
        }
        InstanceAccess other = (InstanceAccess)obj;
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.operatingSystem() == null ^ this.operatingSystem() == null) {
            return false;
        }
        if (other.operatingSystem() != null && !other.operatingSystem().equals(this.operatingSystem())) {
            return false;
        }
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        return other.credentials() == null || other.credentials().equals(this.credentials());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.operatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.operatingSystem()).append(",");
        }
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAccessMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String instanceId;
        private String ipAddress;
        private String operatingSystem;
        private InstanceCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccess model) {
            this.setFleetId(model.fleetId);
            this.setInstanceId(model.instanceId);
            this.setIpAddress(model.ipAddress);
            this.setOperatingSystem(model.operatingSystem);
            this.setCredentials(model.credentials);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final InstanceCredentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final Builder credentials(InstanceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(InstanceCredentials credentials) {
            this.credentials = credentials;
        }

        public InstanceAccess build() {
            return new InstanceAccess(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAccess> {
        public Builder fleetId(String var1);

        public Builder instanceId(String var1);

        public Builder ipAddress(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder credentials(InstanceCredentials var1);
    }
}

