/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.FleetIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetUtilizationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeFleetUtilizationRequest> {
    private final List<String> fleetIds;
    private final Integer limit;
    private final String nextToken;

    private DescribeFleetUtilizationRequest(BuilderImpl builder) {
        this.fleetIds = builder.fleetIds;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public List<String> fleetIds() {
        return this.fleetIds;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetIds() == null ? 0 : this.fleetIds().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetUtilizationRequest)) {
            return false;
        }
        DescribeFleetUtilizationRequest other = (DescribeFleetUtilizationRequest)((Object)obj);
        if (other.fleetIds() == null ^ this.fleetIds() == null) {
            return false;
        }
        if (other.fleetIds() != null && !other.fleetIds().equals(this.fleetIds())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetIds() != null) {
            sb.append("FleetIds: ").append(this.fleetIds()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> fleetIds;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetUtilizationRequest model) {
            this.setFleetIds(model.fleetIds);
            this.setLimit(model.limit);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getFleetIds() {
            return this.fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdListCopier.copy(fleetIds);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFleetUtilizationRequest build() {
            return new DescribeFleetUtilizationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetUtilizationRequest> {
        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);
    }
}

