/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlayerSessionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlayerSessionRequest> {
    private final String gameSessionId;
    private final String playerId;
    private final String playerData;

    private CreatePlayerSessionRequest(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerData() {
        return this.playerData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.playerId() == null ? 0 : this.playerId().hashCode());
        hashCode = 31 * hashCode + (this.playerData() == null ? 0 : this.playerData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionRequest)) {
            return false;
        }
        CreatePlayerSessionRequest other = (CreatePlayerSessionRequest)((Object)obj);
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.playerId() == null ^ this.playerId() == null) {
            return false;
        }
        if (other.playerId() != null && !other.playerId().equals(this.playerId())) {
            return false;
        }
        if (other.playerData() == null ^ this.playerData() == null) {
            return false;
        }
        return other.playerData() == null || other.playerData().equals(this.playerData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.playerData() != null) {
            sb.append("PlayerData: ").append(this.playerData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionRequest model) {
            this.setGameSessionId(model.gameSessionId);
            this.setPlayerId(model.playerId);
            this.setPlayerData(model.playerData);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        public CreatePlayerSessionRequest build() {
            return new CreatePlayerSessionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlayerSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerData(String var1);
    }
}

