/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.ServerProcess;

@SdkInternalApi
public class ServerProcessMarshaller {
    private static final MarshallingInfo<String> LAUNCHPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchPath").build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<Integer> CONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConcurrentExecutions").build();
    private static final ServerProcessMarshaller INSTANCE = new ServerProcessMarshaller();

    public static ServerProcessMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServerProcess serverProcess, ProtocolMarshaller protocolMarshaller) {
        if (serverProcess == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)serverProcess.launchPath(), LAUNCHPATH_BINDING);
            protocolMarshaller.marshall((Object)serverProcess.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)serverProcess.concurrentExecutions(), CONCURRENTEXECUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

