/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.transform.EC2InstanceLimitMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EC2InstanceLimit
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2InstanceLimit> {
    private final String ec2InstanceType;
    private final Integer currentInstances;
    private final Integer instanceLimit;

    private EC2InstanceLimit(BuilderImpl builder) {
        this.ec2InstanceType = builder.ec2InstanceType;
        this.currentInstances = builder.currentInstances;
        this.instanceLimit = builder.instanceLimit;
    }

    public String ec2InstanceType() {
        return this.ec2InstanceType;
    }

    public Integer currentInstances() {
        return this.currentInstances;
    }

    public Integer instanceLimit() {
        return this.instanceLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ec2InstanceType() == null ? 0 : this.ec2InstanceType().hashCode());
        hashCode = 31 * hashCode + (this.currentInstances() == null ? 0 : this.currentInstances().hashCode());
        hashCode = 31 * hashCode + (this.instanceLimit() == null ? 0 : this.instanceLimit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceLimit)) {
            return false;
        }
        EC2InstanceLimit other = (EC2InstanceLimit)obj;
        if (other.ec2InstanceType() == null ^ this.ec2InstanceType() == null) {
            return false;
        }
        if (other.ec2InstanceType() != null && !other.ec2InstanceType().equals(this.ec2InstanceType())) {
            return false;
        }
        if (other.currentInstances() == null ^ this.currentInstances() == null) {
            return false;
        }
        if (other.currentInstances() != null && !other.currentInstances().equals(this.currentInstances())) {
            return false;
        }
        if (other.instanceLimit() == null ^ this.instanceLimit() == null) {
            return false;
        }
        return other.instanceLimit() == null || other.instanceLimit().equals(this.instanceLimit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ec2InstanceType() != null) {
            sb.append("EC2InstanceType: ").append(this.ec2InstanceType()).append(",");
        }
        if (this.currentInstances() != null) {
            sb.append("CurrentInstances: ").append(this.currentInstances()).append(",");
        }
        if (this.instanceLimit() != null) {
            sb.append("InstanceLimit: ").append(this.instanceLimit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2InstanceLimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String ec2InstanceType;
        private Integer currentInstances;
        private Integer instanceLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceLimit model) {
            this.setEC2InstanceType(model.ec2InstanceType);
            this.setCurrentInstances(model.currentInstances);
            this.setInstanceLimit(model.instanceLimit);
        }

        public final String getEC2InstanceType() {
            return this.ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType.toString());
            return this;
        }

        public final void setEC2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final Integer getCurrentInstances() {
            return this.currentInstances;
        }

        @Override
        public final Builder currentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
            return this;
        }

        public final void setCurrentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
        }

        public final Integer getInstanceLimit() {
            return this.instanceLimit;
        }

        @Override
        public final Builder instanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
            return this;
        }

        public final void setInstanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
        }

        public EC2InstanceLimit build() {
            return new EC2InstanceLimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2InstanceLimit> {
        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder currentInstances(Integer var1);

        public Builder instanceLimit(Integer var1);
    }
}

