/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.IpPermission;

@SdkInternalApi
public class IpPermissionMarshaller {
    private static final MarshallingInfo<Integer> FROMPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromPort").build();
    private static final MarshallingInfo<Integer> TOPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToPort").build();
    private static final MarshallingInfo<String> IPRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpRange").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocol").build();
    private static final IpPermissionMarshaller instance = new IpPermissionMarshaller();

    public static IpPermissionMarshaller getInstance() {
        return instance;
    }

    public void marshall(IpPermission ipPermission, ProtocolMarshaller protocolMarshaller) {
        if (ipPermission == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ipPermission.fromPort(), FROMPORT_BINDING);
            protocolMarshaller.marshall((Object)ipPermission.toPort(), TOPORT_BINDING);
            protocolMarshaller.marshall((Object)ipPermission.ipRange(), IPRANGE_BINDING);
            protocolMarshaller.marshall((Object)ipPermission.protocol(), PROTOCOL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

