/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType;
import software.amazon.awssdk.services.gamelift.model.MetricName;
import software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType;
import software.amazon.awssdk.services.gamelift.model.ScalingStatusType;
import software.amazon.awssdk.services.gamelift.transform.ScalingPolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private final String fleetId;
    private final String name;
    private final String status;
    private final Integer scalingAdjustment;
    private final String scalingAdjustmentType;
    private final String comparisonOperator;
    private final Double threshold;
    private final Integer evaluationPeriods;
    private final String metricName;

    private ScalingPolicy(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.name = builder.name;
        this.status = builder.status;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.scalingAdjustmentType = builder.scalingAdjustmentType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public String scalingAdjustmentType() {
        return this.scalingAdjustmentType;
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public String metricName() {
        return this.metricName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustment() == null ? 0 : this.scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustmentType() == null ? 0 : this.scalingAdjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.comparisonOperator() == null ? 0 : this.comparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.threshold() == null ? 0 : this.threshold().hashCode());
        hashCode = 31 * hashCode + (this.evaluationPeriods() == null ? 0 : this.evaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.scalingAdjustmentType() == null ^ this.scalingAdjustmentType() == null) {
            return false;
        }
        if (other.scalingAdjustmentType() != null && !other.scalingAdjustmentType().equals(this.scalingAdjustmentType())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        if (other.evaluationPeriods() == null ^ this.evaluationPeriods() == null) {
            return false;
        }
        if (other.evaluationPeriods() != null && !other.evaluationPeriods().equals(this.evaluationPeriods())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        return other.metricName() == null || other.metricName().equals(this.metricName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(this.scalingAdjustment()).append(",");
        }
        if (this.scalingAdjustmentType() != null) {
            sb.append("ScalingAdjustmentType: ").append(this.scalingAdjustmentType()).append(",");
        }
        if (this.comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperator()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        if (this.evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.evaluationPeriods()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String name;
        private String status;
        private Integer scalingAdjustment;
        private String scalingAdjustmentType;
        private String comparisonOperator;
        private Double threshold;
        private Integer evaluationPeriods;
        private String metricName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.setFleetId(model.fleetId);
            this.setName(model.name);
            this.setStatus(model.status);
            this.setScalingAdjustment(model.scalingAdjustment);
            this.setScalingAdjustmentType(model.scalingAdjustmentType);
            this.setComparisonOperator(model.comparisonOperator);
            this.setThreshold(model.threshold);
            this.setEvaluationPeriods(model.evaluationPeriods);
            this.setMetricName(model.metricName);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScalingStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ScalingStatusType status) {
            this.status(status.toString());
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final String getScalingAdjustmentType() {
            return this.scalingAdjustmentType;
        }

        @Override
        public final Builder scalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
            return this;
        }

        @Override
        public final Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType.toString());
            return this;
        }

        public final void setScalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
        }

        public final void setScalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType.toString());
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final void setComparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final void setMetricName(MetricName metricName) {
            this.metricName(metricName.toString());
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingPolicy> {
        public Builder fleetId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ScalingStatusType var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder scalingAdjustmentType(String var1);

        public Builder scalingAdjustmentType(ScalingAdjustmentType var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperatorType var1);

        public Builder threshold(Double var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);
    }
}

