/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.PlayerLatencyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlayerLatency
implements StructuredPojo,
ToCopyableBuilder<Builder, PlayerLatency> {
    private final String playerId;
    private final String regionIdentifier;
    private final Float latencyInMilliseconds;

    private PlayerLatency(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.regionIdentifier = builder.regionIdentifier;
        this.latencyInMilliseconds = builder.latencyInMilliseconds;
    }

    public String playerId() {
        return this.playerId;
    }

    public String regionIdentifier() {
        return this.regionIdentifier;
    }

    public Float latencyInMilliseconds() {
        return this.latencyInMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.playerId() == null ? 0 : this.playerId().hashCode());
        hashCode = 31 * hashCode + (this.regionIdentifier() == null ? 0 : this.regionIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.latencyInMilliseconds() == null ? 0 : this.latencyInMilliseconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatency)) {
            return false;
        }
        PlayerLatency other = (PlayerLatency)obj;
        if (other.playerId() == null ^ this.playerId() == null) {
            return false;
        }
        if (other.playerId() != null && !other.playerId().equals(this.playerId())) {
            return false;
        }
        if (other.regionIdentifier() == null ^ this.regionIdentifier() == null) {
            return false;
        }
        if (other.regionIdentifier() != null && !other.regionIdentifier().equals(this.regionIdentifier())) {
            return false;
        }
        if (other.latencyInMilliseconds() == null ^ this.latencyInMilliseconds() == null) {
            return false;
        }
        return other.latencyInMilliseconds() == null || other.latencyInMilliseconds().equals(this.latencyInMilliseconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.playerId() != null) {
            sb.append("PlayerId: ").append(this.playerId()).append(",");
        }
        if (this.regionIdentifier() != null) {
            sb.append("RegionIdentifier: ").append(this.regionIdentifier()).append(",");
        }
        if (this.latencyInMilliseconds() != null) {
            sb.append("LatencyInMilliseconds: ").append(this.latencyInMilliseconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PlayerLatencyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String regionIdentifier;
        private Float latencyInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatency model) {
            this.setPlayerId(model.playerId);
            this.setRegionIdentifier(model.regionIdentifier);
            this.setLatencyInMilliseconds(model.latencyInMilliseconds);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getRegionIdentifier() {
            return this.regionIdentifier;
        }

        @Override
        public final Builder regionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
            return this;
        }

        public final void setRegionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
        }

        public final Float getLatencyInMilliseconds() {
            return this.latencyInMilliseconds;
        }

        @Override
        public final Builder latencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
            return this;
        }

        public final void setLatencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
        }

        public PlayerLatency build() {
            return new PlayerLatency(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlayerLatency> {
        public Builder playerId(String var1);

        public Builder regionIdentifier(String var1);

        public Builder latencyInMilliseconds(Float var1);
    }
}

