/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.gamelift.model.Alias;
import software.amazon.awssdk.services.gamelift.model.AliasListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAliasesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAliasesResponse> {
    private final List<Alias> aliases;
    private final String nextToken;

    private ListAliasesResponse(BuilderImpl builder) {
        this.aliases = builder.aliases;
        this.nextToken = builder.nextToken;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aliases() == null ? 0 : this.aliases().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResponse)) {
            return false;
        }
        ListAliasesResponse other = (ListAliasesResponse)((Object)obj);
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        if (other.aliases() != null && !other.aliases().equals(this.aliases())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aliases() != null) {
            sb.append("Aliases: ").append(this.aliases()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Alias> aliases;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesResponse model) {
            this.setAliases(model.aliases);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Alias> getAliases() {
            return this.aliases;
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final void setAliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
        }

        @SafeVarargs
        public final void setAliases(Alias ... aliases) {
            this.aliases(Arrays.asList(aliases));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListAliasesResponse build() {
            return new ListAliasesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAliasesResponse> {
        public Builder aliases(Collection<Alias> var1);

        public Builder aliases(Alias ... var1);

        public Builder nextToken(String var1);
    }
}

