/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.FleetUtilizationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FleetUtilization
implements StructuredPojo,
ToCopyableBuilder<Builder, FleetUtilization> {
    private final String fleetId;
    private final Integer activeServerProcessCount;
    private final Integer activeGameSessionCount;
    private final Integer currentPlayerSessionCount;
    private final Integer maximumPlayerSessionCount;

    private FleetUtilization(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.activeServerProcessCount = builder.activeServerProcessCount;
        this.activeGameSessionCount = builder.activeGameSessionCount;
        this.currentPlayerSessionCount = builder.currentPlayerSessionCount;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Integer activeServerProcessCount() {
        return this.activeServerProcessCount;
    }

    public Integer activeGameSessionCount() {
        return this.activeGameSessionCount;
    }

    public Integer currentPlayerSessionCount() {
        return this.currentPlayerSessionCount;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleetId() == null ? 0 : this.fleetId().hashCode());
        hashCode = 31 * hashCode + (this.activeServerProcessCount() == null ? 0 : this.activeServerProcessCount().hashCode());
        hashCode = 31 * hashCode + (this.activeGameSessionCount() == null ? 0 : this.activeGameSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.currentPlayerSessionCount() == null ? 0 : this.currentPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.maximumPlayerSessionCount() == null ? 0 : this.maximumPlayerSessionCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetUtilization)) {
            return false;
        }
        FleetUtilization other = (FleetUtilization)obj;
        if (other.fleetId() == null ^ this.fleetId() == null) {
            return false;
        }
        if (other.fleetId() != null && !other.fleetId().equals(this.fleetId())) {
            return false;
        }
        if (other.activeServerProcessCount() == null ^ this.activeServerProcessCount() == null) {
            return false;
        }
        if (other.activeServerProcessCount() != null && !other.activeServerProcessCount().equals(this.activeServerProcessCount())) {
            return false;
        }
        if (other.activeGameSessionCount() == null ^ this.activeGameSessionCount() == null) {
            return false;
        }
        if (other.activeGameSessionCount() != null && !other.activeGameSessionCount().equals(this.activeGameSessionCount())) {
            return false;
        }
        if (other.currentPlayerSessionCount() == null ^ this.currentPlayerSessionCount() == null) {
            return false;
        }
        if (other.currentPlayerSessionCount() != null && !other.currentPlayerSessionCount().equals(this.currentPlayerSessionCount())) {
            return false;
        }
        if (other.maximumPlayerSessionCount() == null ^ this.maximumPlayerSessionCount() == null) {
            return false;
        }
        return other.maximumPlayerSessionCount() == null || other.maximumPlayerSessionCount().equals(this.maximumPlayerSessionCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleetId() != null) {
            sb.append("FleetId: ").append(this.fleetId()).append(",");
        }
        if (this.activeServerProcessCount() != null) {
            sb.append("ActiveServerProcessCount: ").append(this.activeServerProcessCount()).append(",");
        }
        if (this.activeGameSessionCount() != null) {
            sb.append("ActiveGameSessionCount: ").append(this.activeGameSessionCount()).append(",");
        }
        if (this.currentPlayerSessionCount() != null) {
            sb.append("CurrentPlayerSessionCount: ").append(this.currentPlayerSessionCount()).append(",");
        }
        if (this.maximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.maximumPlayerSessionCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetUtilizationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private Integer activeServerProcessCount;
        private Integer activeGameSessionCount;
        private Integer currentPlayerSessionCount;
        private Integer maximumPlayerSessionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetUtilization model) {
            this.setFleetId(model.fleetId);
            this.setActiveServerProcessCount(model.activeServerProcessCount);
            this.setActiveGameSessionCount(model.activeGameSessionCount);
            this.setCurrentPlayerSessionCount(model.currentPlayerSessionCount);
            this.setMaximumPlayerSessionCount(model.maximumPlayerSessionCount);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Integer getActiveServerProcessCount() {
            return this.activeServerProcessCount;
        }

        @Override
        public final Builder activeServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
            return this;
        }

        public final void setActiveServerProcessCount(Integer activeServerProcessCount) {
            this.activeServerProcessCount = activeServerProcessCount;
        }

        public final Integer getActiveGameSessionCount() {
            return this.activeGameSessionCount;
        }

        @Override
        public final Builder activeGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
            return this;
        }

        public final void setActiveGameSessionCount(Integer activeGameSessionCount) {
            this.activeGameSessionCount = activeGameSessionCount;
        }

        public final Integer getCurrentPlayerSessionCount() {
            return this.currentPlayerSessionCount;
        }

        @Override
        public final Builder currentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
            return this;
        }

        public final void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
            this.currentPlayerSessionCount = currentPlayerSessionCount;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public FleetUtilization build() {
            return new FleetUtilization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetUtilization> {
        public Builder fleetId(String var1);

        public Builder activeServerProcessCount(Integer var1);

        public Builder activeGameSessionCount(Integer var1);

        public Builder currentPlayerSessionCount(Integer var1);

        public Builder maximumPlayerSessionCount(Integer var1);
    }
}

