/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.EC2InstanceCountsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EC2InstanceCounts
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2InstanceCounts> {
    private final Integer desired;
    private final Integer minimum;
    private final Integer maximum;
    private final Integer pending;
    private final Integer active;
    private final Integer idle;
    private final Integer terminating;

    private EC2InstanceCounts(BuilderImpl builder) {
        this.desired = builder.desired;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.pending = builder.pending;
        this.active = builder.active;
        this.idle = builder.idle;
        this.terminating = builder.terminating;
    }

    public Integer desired() {
        return this.desired;
    }

    public Integer minimum() {
        return this.minimum;
    }

    public Integer maximum() {
        return this.maximum;
    }

    public Integer pending() {
        return this.pending;
    }

    public Integer active() {
        return this.active;
    }

    public Integer idle() {
        return this.idle;
    }

    public Integer terminating() {
        return this.terminating;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.desired() == null ? 0 : this.desired().hashCode());
        hashCode = 31 * hashCode + (this.minimum() == null ? 0 : this.minimum().hashCode());
        hashCode = 31 * hashCode + (this.maximum() == null ? 0 : this.maximum().hashCode());
        hashCode = 31 * hashCode + (this.pending() == null ? 0 : this.pending().hashCode());
        hashCode = 31 * hashCode + (this.active() == null ? 0 : this.active().hashCode());
        hashCode = 31 * hashCode + (this.idle() == null ? 0 : this.idle().hashCode());
        hashCode = 31 * hashCode + (this.terminating() == null ? 0 : this.terminating().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceCounts)) {
            return false;
        }
        EC2InstanceCounts other = (EC2InstanceCounts)obj;
        if (other.desired() == null ^ this.desired() == null) {
            return false;
        }
        if (other.desired() != null && !other.desired().equals(this.desired())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        if (other.pending() == null ^ this.pending() == null) {
            return false;
        }
        if (other.pending() != null && !other.pending().equals(this.pending())) {
            return false;
        }
        if (other.active() == null ^ this.active() == null) {
            return false;
        }
        if (other.active() != null && !other.active().equals(this.active())) {
            return false;
        }
        if (other.idle() == null ^ this.idle() == null) {
            return false;
        }
        if (other.idle() != null && !other.idle().equals(this.idle())) {
            return false;
        }
        if (other.terminating() == null ^ this.terminating() == null) {
            return false;
        }
        return other.terminating() == null || other.terminating().equals(this.terminating());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.desired() != null) {
            sb.append("DESIRED: ").append(this.desired()).append(",");
        }
        if (this.minimum() != null) {
            sb.append("MINIMUM: ").append(this.minimum()).append(",");
        }
        if (this.maximum() != null) {
            sb.append("MAXIMUM: ").append(this.maximum()).append(",");
        }
        if (this.pending() != null) {
            sb.append("PENDING: ").append(this.pending()).append(",");
        }
        if (this.active() != null) {
            sb.append("ACTIVE: ").append(this.active()).append(",");
        }
        if (this.idle() != null) {
            sb.append("IDLE: ").append(this.idle()).append(",");
        }
        if (this.terminating() != null) {
            sb.append("TERMINATING: ").append(this.terminating()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2InstanceCountsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer desired;
        private Integer minimum;
        private Integer maximum;
        private Integer pending;
        private Integer active;
        private Integer idle;
        private Integer terminating;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceCounts model) {
            this.setDESIRED(model.desired);
            this.setMINIMUM(model.minimum);
            this.setMAXIMUM(model.maximum);
            this.setPENDING(model.pending);
            this.setACTIVE(model.active);
            this.setIDLE(model.idle);
            this.setTERMINATING(model.terminating);
        }

        public final Integer getDESIRED() {
            return this.desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final void setDESIRED(Integer desired) {
            this.desired = desired;
        }

        public final Integer getMINIMUM() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMINIMUM(Integer minimum) {
            this.minimum = minimum;
        }

        public final Integer getMAXIMUM() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMAXIMUM(Integer maximum) {
            this.maximum = maximum;
        }

        public final Integer getPENDING() {
            return this.pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final void setPENDING(Integer pending) {
            this.pending = pending;
        }

        public final Integer getACTIVE() {
            return this.active;
        }

        @Override
        public final Builder active(Integer active) {
            this.active = active;
            return this;
        }

        public final void setACTIVE(Integer active) {
            this.active = active;
        }

        public final Integer getIDLE() {
            return this.idle;
        }

        @Override
        public final Builder idle(Integer idle) {
            this.idle = idle;
            return this;
        }

        public final void setIDLE(Integer idle) {
            this.idle = idle;
        }

        public final Integer getTERMINATING() {
            return this.terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        public final void setTERMINATING(Integer terminating) {
            this.terminating = terminating;
        }

        public EC2InstanceCounts build() {
            return new EC2InstanceCounts(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2InstanceCounts> {
        public Builder desired(Integer var1);

        public Builder minimum(Integer var1);

        public Builder maximum(Integer var1);

        public Builder pending(Integer var1);

        public Builder active(Integer var1);

        public Builder idle(Integer var1);

        public Builder terminating(Integer var1);
    }
}

