/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.gamelift.model.PlayerDataMapCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlayerSessionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlayerSessionsRequest> {
    private final String gameSessionId;
    private final List<String> playerIds;
    private final Map<String, String> playerDataMap;

    private CreatePlayerSessionsRequest(BuilderImpl builder) {
        this.gameSessionId = builder.gameSessionId;
        this.playerIds = builder.playerIds;
        this.playerDataMap = builder.playerDataMap;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public List<String> playerIds() {
        return this.playerIds;
    }

    public Map<String, String> playerDataMap() {
        return this.playerDataMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.gameSessionId() == null ? 0 : this.gameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.playerIds() == null ? 0 : this.playerIds().hashCode());
        hashCode = 31 * hashCode + (this.playerDataMap() == null ? 0 : this.playerDataMap().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsRequest)) {
            return false;
        }
        CreatePlayerSessionsRequest other = (CreatePlayerSessionsRequest)((Object)obj);
        if (other.gameSessionId() == null ^ this.gameSessionId() == null) {
            return false;
        }
        if (other.gameSessionId() != null && !other.gameSessionId().equals(this.gameSessionId())) {
            return false;
        }
        if (other.playerIds() == null ^ this.playerIds() == null) {
            return false;
        }
        if (other.playerIds() != null && !other.playerIds().equals(this.playerIds())) {
            return false;
        }
        if (other.playerDataMap() == null ^ this.playerDataMap() == null) {
            return false;
        }
        return other.playerDataMap() == null || other.playerDataMap().equals(this.playerDataMap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.gameSessionId()).append(",");
        }
        if (this.playerIds() != null) {
            sb.append("PlayerIds: ").append(this.playerIds()).append(",");
        }
        if (this.playerDataMap() != null) {
            sb.append("PlayerDataMap: ").append(this.playerDataMap()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String gameSessionId;
        private List<String> playerIds;
        private Map<String, String> playerDataMap;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionsRequest model) {
            this.setGameSessionId(model.gameSessionId);
            this.setPlayerIds(model.playerIds);
            this.setPlayerDataMap(model.playerDataMap);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Collection<String> getPlayerIds() {
            return this.playerIds;
        }

        @Override
        public final Builder playerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerIds(String ... playerIds) {
            this.playerIds(Arrays.asList(playerIds));
            return this;
        }

        public final void setPlayerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
        }

        @SafeVarargs
        public final void setPlayerIds(String ... playerIds) {
            this.playerIds(Arrays.asList(playerIds));
        }

        public final Map<String, String> getPlayerDataMap() {
            return this.playerDataMap;
        }

        @Override
        public final Builder playerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
            return this;
        }

        public final void setPlayerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
        }

        public CreatePlayerSessionsRequest build() {
            return new CreatePlayerSessionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlayerSessionsRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerIds(Collection<String> var1);

        public Builder playerIds(String ... var1);

        public Builder playerDataMap(Map<String, String> var1);
    }
}

