/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.InstanceAccess;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceAccessMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATINGSYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingSystem").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Credentials").isBinary(false).build();
    private static final InstanceAccessMarshaller INSTANCE = new InstanceAccessMarshaller();

    private InstanceAccessMarshaller() {
    }

    public static InstanceAccessMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceAccess instanceAccess, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceAccess, (String)"instanceAccess");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceAccess.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)instanceAccess.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceAccess.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instanceAccess.operatingSystemAsString(), OPERATINGSYSTEM_BINDING);
            protocolMarshaller.marshall((Object)instanceAccess.credentials(), CREDENTIALS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

